/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ElfDiffHelper {
    private static final Logger _logger = Logger.getLogger(ElfDiffHelper.class.getName());
    private static ElfDiffHelper _instance;
    private static boolean _loaded;
    private static String _elfdiffPath;
    private static String[] defaultExtensions;
    private String[] extensions = null;

    private ElfDiffHelper() {
    }

    public static ElfDiffHelper getInstance() {
        if (_instance == null) {
            _instance = new ElfDiffHelper();
        }
        return _instance;
    }

    public void loadResource(String path) {
        _logger.finest("Trying to load resource: " + path);
        File elfdiffPath = new File(path);
        if (elfdiffPath.exists() && elfdiffPath.canExecute()) {
            _loaded = true;
            _elfdiffPath = elfdiffPath.getAbsolutePath();
            _logger.finest("Resource was loaded succesfully");
        } else {
            _logger.warning("ELF file can't be loaded: Exist? " + elfdiffPath.exists() + " Execute? " + elfdiffPath.canExecute());
        }
    }

    public boolean isElfFile(File tmpRootFile) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/usr/bin/file");
        commands.add("-L");
        commands.add(tmpRootFile.getAbsolutePath());
        try {
            _logger.finest("Executing command " + commands);
            return this.executeCommand(commands, "ELF");
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage());
            return false;
        }
    }

    public boolean validateDiff(File tmpRootFile, File tmpDiffInnerFile) throws Exception {
        boolean isDifferent = false;
        ArrayList<String> commands = new ArrayList<String>();
        commands.clear();
        commands.add(this.getElfdiffPath());
        commands.add("-debug");
        commands.add(tmpRootFile.getAbsolutePath());
        commands.add(tmpDiffInnerFile.getAbsolutePath());
        _logger.finest("Running command: " + this.getElfdiffPath() + " -debug " + tmpRootFile.getAbsolutePath() + tmpDiffInnerFile.getAbsolutePath());
        isDifferent = !this.executeCommand(commands, "same");
        return isDifferent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(List<String> command, String expectedValue) throws Exception {
        int exitValue;
        String errorLine;
        String line;
        boolean result = false;
        String errorString = null;
        ProcessBuilder pb = new ProcessBuilder(command);
        Process process = pb.start();
        BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader errorOutput = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = output.readLine()) != null) {
            if (line.contains(expectedValue)) {
                result = true;
            }
            if (!line.contains("Error")) continue;
            errorString = new String(line);
        }
        while ((errorLine = errorOutput.readLine()) != null) {
            if (errorLine.contains(expectedValue)) {
                result = true;
            }
            if (!errorLine.contains("Error")) continue;
            errorString = new String(errorLine);
        }
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException e) {
            _logger.log(Level.FINEST, e.getMessage(), e);
            exitValue = 1;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (errorOutput != null) {
                errorOutput.close();
            }
        }
        if (errorString != null) {
            throw new Exception("ElfDiff returned an error: " + errorString);
        }
        if (exitValue != 0) {
            return false;
        }
        return result;
    }

    public void registerExtensions(String[] exts) {
        if (exts == null) {
            _logger.warning("No extensions received, using default extensions");
            exts = defaultExtensions;
        }
        this.extensions = exts;
    }

    public String[] getExtesnions() {
        String[] exts = null;
        if (this.extensions == null) {
            exts = defaultExtensions;
            _logger.warning("No extensions were registered, using default extensions");
        } else {
            exts = this.extensions;
        }
        return exts;
    }

    public boolean isLoaded() {
        return _loaded;
    }

    public String getElfdiffPath() {
        return _elfdiffPath;
    }

    static {
        _loaded = false;
        _elfdiffPath = null;
        defaultExtensions = new String[]{"a", "so", "o"};
    }
}

