/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.DirectoryBackup;
import com.oracle.cie.common.util.FileCopy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryCopy {
    public static final Logger s_logger = Logger.getLogger(DirectoryBackup.class.getName());

    public static void copy(File from, File to) throws IOException {
        DirectoryCopy.copy(from, to, null);
    }

    public static void copy(File from, File to, FileFilter filter) throws IOException {
        if (from == null || !from.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid directory to copy from.");
        }
        if (to == null || to.exists() && !to.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid directory to copy to.");
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Directory copy: " + from.getPath() + " to " + to.getPath());
        }
        if (!to.exists()) {
            to.mkdirs();
        }
        File[] fl = from.listFiles(filter);
        for (int i = 0; i < fl.length; ++i) {
            if (fl[i].isDirectory()) {
                DirectoryCopy.copy(fl[i], new File(to, fl[i].getName()), filter);
                continue;
            }
            FileCopy.copy(fl[i], new File(to, fl[i].getName()));
        }
    }
}

