/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DirectoryBackup {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final Logger s_logger = Logger.getLogger(DirectoryBackup.class.getName());

    public static void performZip(File directory, boolean recurse, File outputZip, boolean overwrite, ZipObservable observable, int buffSize) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid directory.");
        }
        if (outputZip == null) {
            throw new IllegalArgumentException("You must provide a valid output file.");
        }
        if (outputZip.exists()) {
            if (!overwrite) {
                throw new IOException("Backup file already exists");
            }
            outputZip.delete();
        }
        List fileList = DirectoryBackup.getFiles(directory, recurse);
        DirectoryBackup.performZip(fileList, directory, outputZip, overwrite, observable, buffSize);
    }

    public static void performZip(List fileList, File baseDirectory, File outputZip, boolean overwrite, ZipObservable observable, int buffSize) throws IOException {
        if (fileList == null) {
            throw new IllegalArgumentException("You must provide a list of files.");
        }
        if (outputZip == null) {
            throw new IllegalArgumentException("You must provide a non-existent valid output file.");
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException("You must provide a base directory.");
        }
        if (outputZip.exists()) {
            if (!overwrite) {
                throw new IOException("Backup file already exists");
            }
            outputZip.delete();
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputZip));
        byte[] buff = new byte[buffSize > 0 ? buffSize : 8192];
        File f = null;
        FileInputStream fis = null;
        ZipEntry zipEntry = null;
        int bytesRead = -1;
        int baseDirLength = baseDirectory.getPath().length();
        ListIterator lit = fileList.listIterator();
        while (lit.hasNext()) {
            f = (File)lit.next();
            if (observable != null) {
                observable.setChanged();
                observable.notifyObservers(f);
            }
            if (s_logger.isLoggable(Level.FINE)) {
                s_logger.fine("Backing up file: " + f.getAbsolutePath());
            }
            try {
                zipEntry = new ZipEntry(f.getAbsolutePath().substring(baseDirLength + 1) + (f.isDirectory() ? "/" : ""));
            }
            catch (IndexOutOfBoundsException iobx) {
                s_logger.log(Level.SEVERE, "All files don't have the same base directory.", iobx);
                throw new IOException("All files don't have the same base directory.");
            }
            zos.putNextEntry(zipEntry);
            if (!zipEntry.isDirectory()) {
                fis = new FileInputStream(f);
                while ((bytesRead = fis.read(buff)) != -1) {
                    zos.write(buff, 0, bytesRead);
                }
                fis.close();
            }
            zos.closeEntry();
        }
        if (observable != null) {
            observable.setChanged();
            observable.notifyObservers(f);
        }
        zos.close();
    }

    public static List getFiles(File directory, boolean recurse) {
        if (directory == null || !directory.isDirectory() || !directory.exists()) {
            throw new IllegalArgumentException("You must provide a valid existing directory.");
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Listing files in: " + directory.getAbsolutePath());
        }
        File[] files = directory.listFiles();
        ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(files));
        if (recurse) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                fileList.addAll(DirectoryBackup.getFiles(files[i], recurse));
            }
        }
        return fileList;
    }

    public static long calculateBytes(List fileList) {
        long totalBytes = 0L;
        if (fileList != null && !fileList.isEmpty()) {
            File f = null;
            for (int i = 0; i < fileList.size(); ++i) {
                f = (File)fileList.get(i);
                totalBytes += f.length();
            }
        }
        return totalBytes;
    }

    public static class ZipObservable
    extends Observable {
        @Override
        protected void setChanged() {
            super.setChanged();
        }
    }
}

