/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Observable;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;

public class Checksum
extends Observable
implements Runnable {
    private static final int[] crc32_table = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private File _file = null;
    private boolean _shutdown = false;
    private boolean _paused = false;
    private int _crc = -1;
    private int[] _pt = new int[]{0, 0};

    public static String getMD5Checksum(File file) throws NoSuchAlgorithmException, IOException {
        return Checksum.getChecksum(file, ChecksumAlgorithm.MD5.name());
    }

    public static String getSHAChecksum(File file) throws NoSuchAlgorithmException, IOException {
        return Checksum.getChecksum(file, ChecksumAlgorithm.SHA.name());
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("File not found : " + file.getAbsolutePath());
        }
        FileInputStream inputStream = new FileInputStream(file);
        FileChannel fileChannel = inputStream.getChannel();
        MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(byteBuffer);
        String checksum = DatatypeConverter.printHexBinary((byte[])messageDigest.digest());
        fileChannel.close();
        inputStream.close();
        fileChannel = null;
        inputStream = null;
        byteBuffer = null;
        messageDigest = null;
        System.gc();
        return checksum != null ? checksum.toLowerCase() : null;
    }

    public static String getDirectoryChecksum(File directory, String algorithm) throws NoSuchAlgorithmException, IOException {
        return Checksum.getDirectoryChecksum(directory, null, algorithm);
    }

    public static String getDirectoryChecksum(File directory, FileFilter filter, String algorithm) throws NoSuchAlgorithmException, IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException("Directory not found : " + directory.getAbsolutePath());
        }
        Set<File> files = IOUtil.getFiles(directory, filter);
        return Checksum.getMultiFileChecksum(files, directory.getAbsolutePath().length() + 1, algorithm);
    }

    public static String getMultiFileChecksum(Set<File> files, int pathTrim, String algorithm) throws NoSuchAlgorithmException, IOException {
        if (files.isEmpty()) {
            return "0";
        }
        TreeMap<String, File> sortedMap = new TreeMap<String, File>();
        for (File file : files) {
            sortedMap.put(file.getAbsolutePath().substring(pathTrim).replace("\\", "/"), file);
        }
        String fileChecksums = "";
        for (String path : sortedMap.keySet()) {
            File f = (File)sortedMap.get(path);
            fileChecksums = f.isDirectory() ? fileChecksums + "0 " + path : fileChecksums + Checksum.getChecksum(f, algorithm) + " " + path;
            fileChecksums = fileChecksums + "\n";
        }
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(fileChecksums.getBytes());
        String checksum = DatatypeConverter.printHexBinary((byte[])messageDigest.digest());
        Object var5_8 = null;
        System.gc();
        return checksum != null ? checksum.toLowerCase() : null;
    }

    public static void main(String[] args) {
        File inputFile = null;
        if (args.length != 1) {
            System.out.println("Usage: Checksum <input file name>");
        } else {
            try {
                inputFile = new File(args[0]);
                System.out.println("Checksum for " + inputFile + " = " + Checksum.getFileChksum(inputFile));
            }
            catch (IOException ioe) {
                System.out.println("****[ERROR]****");
                System.out.println("Unable to calculate checksum on " + inputFile);
                ioe.printStackTrace();
                System.out.println("***************");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileChksum(File file) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] byteArray = new byte[32768];
        try {
            int crc = -1;
            int i = 0;
            int j = 0;
            int k = 0;
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            while ((i = bis.read(byteArray, 0, 32768)) != -1) {
                for (j = 0; j < i; ++j) {
                    k = (crc ^ byteArray[j]) & 0xFF;
                    crc = crc >> 8 & 0xFFFFFF ^ crc32_table[k];
                }
            }
            int n = ~crc;
            return n;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            bis = null;
            fis = null;
            byteArray = null;
        }
    }

    public static boolean compareFileChksum(String sum, File file) {
        try {
            return Checksum.compareFileChksum(sum, file, ChecksumAlgorithm.CRC32);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean compareFileChksum(String sum, File file, ChecksumAlgorithm algorithm) {
        if (algorithm == ChecksumAlgorithm.CRC32) {
            try {
                return Checksum.compareFileChksum(Integer.parseInt(sum), file);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            if (algorithm == ChecksumAlgorithm.MD5) {
                try {
                    String md5 = Checksum.getMD5Checksum(file);
                    return md5.equalsIgnoreCase(sum);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("The " + (Object)((Object)algorithm) + " algorithm was not found.", e);
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (algorithm == ChecksumAlgorithm.SHA) {
                try {
                    String sha = Checksum.getSHAChecksum(file);
                    return sha.equalsIgnoreCase(sum);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("The " + (Object)((Object)algorithm) + " algorithm was not found.", e);
                }
                catch (IOException e) {
                    return false;
                }
            }
            throw new IllegalArgumentException("The checksum algorithm specified was not valid " + (Object)((Object)algorithm));
        }
        return false;
    }

    public static boolean compareFileChksum(int sum, File file) {
        int crc = -1;
        try {
            crc = Checksum.getFileChksum(file);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return sum == crc;
    }

    public Checksum(File file) {
        this._file = file;
    }

    public int getCRC() {
        return ~this._crc;
    }

    public int getProgress() {
        return this._pt[0];
    }

    public File getFile() {
        return this._file;
    }

    public boolean isCRCValid(int crc) {
        return this._shutdown && crc == ~this._crc;
    }

    public void pause() {
        this._paused = true;
    }

    public synchronized void resume() {
        this._paused = false;
        this.notify();
    }

    public synchronized void shutdown() {
        this._shutdown = true;
        this.notify();
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._crc = -1;
        int i = 0;
        int j = 0;
        int k = 0;
        byte[] byteArray = new byte[32768];
        BufferedInputStream bis = null;
        try {
            int updateInterval = (int)(this._file.length() / 32768L / 100L);
            int readCount = 0;
            bis = new BufferedInputStream(new FileInputStream(this._file));
            while (!this._shutdown) {
                if (this._paused) {
                    Checksum checksum = this;
                    synchronized (checksum) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                i = bis.read(byteArray, 0, 32768);
                if (i == -1) break;
                this._pt[0] = this._pt[0] + i;
                this._pt[1] = this._pt[1] + i;
                for (j = 0; j < i; ++j) {
                    k = (this._crc ^ byteArray[j]) & 0xFF;
                    this._crc = this._crc >> 8 & 0xFFFFFF ^ crc32_table[k];
                }
                if (++readCount < updateInterval) continue;
                this.setChanged();
                this.notifyObservers(this._pt);
                this._pt[0] = 0;
                readCount = 0;
            }
            this.setChanged();
            this.notifyObservers(this._pt);
        }
        catch (FileNotFoundException fnfx) {
            fnfx.printStackTrace();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception fnfx) {}
        }
        this._shutdown = true;
        this.setChanged();
        this.notifyObservers();
    }

    public static enum ChecksumAlgorithm {
        MD5,
        SHA,
        CRC32;

    }
}

