/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.comdev.ComdevHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserLauncher {
    private static Logger s_logger = Logger.getLogger(BrowserLauncher.class.getName());
    protected static final String[] windowsBrowsers = new String[]{"cmd /c start"};
    protected static final String[] unixBrowsers = new String[]{"firefox", "mozilla", "netscape"};

    public static void openDesktopBrowser(URI uri) {
        Method m;
        Class<?> desktopClass = null;
        try {
            desktopClass = Class.forName("java.awt.Desktop");
            if (desktopClass != null && !((Boolean)(m = desktopClass.getMethod("isDesktopSupported", new Class[0])).invoke(null, new Object[0])).booleanValue()) {
                desktopClass = null;
            }
        }
        catch (Exception e) {
            s_logger.fine("Unable to access java.awt.Desktop class, assuming use of jdk prior to 1.6 " + e);
        }
        try {
            if (desktopClass != null && !ComdevHelper.cIsWin32) {
                s_logger.fine("Attemptng to open browser using Desktop class.");
                m = desktopClass.getMethod("getDesktop", new Class[0]);
                Object desktopObj = m.invoke(null, new Object[0]);
                if (desktopObj != null) {
                    m = desktopClass.getMethod("browse", URI.class);
                    m.invoke(desktopObj, uri);
                }
            } else {
                s_logger.info("jdk used is : " + System.getProperty("java.version"));
                s_logger.fine("JDK doesn't support Desktop, attempting to open browser using BrowserLauncher.");
                BrowserLauncher.openURL(uri.toURL().toExternalForm());
            }
        }
        catch (Throwable ex) {
            if (ex != null && ex.getCause() != null) {
                ex = ex.getCause();
            }
            s_logger.log(Level.SEVERE, "Location couldn't be opened", ex);
        }
    }

    public static void openURL(String url) throws IOException {
        boolean success = false;
        String[] browsers = BrowserLauncher.getBrowsers();
        for (int i = 0; i < browsers.length; ++i) {
            try {
                s_logger.fine(browsers[i] + " " + url.replaceAll(" ", "%20"));
                Runtime.getRuntime().exec(browsers[i] + " " + url.replaceAll(" ", "%20"));
                success = true;
                break;
            }
            catch (IOException e) {
                s_logger.fine(e.toString());
                continue;
            }
        }
        if (!success) {
            throw new IOException("Failed to locate browser executable");
        }
    }

    protected static String[] getBrowsers() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            return windowsBrowsers;
        }
        return unixBrowsers;
    }
}

