/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.net;

import com.oracle.cie.common.net.Downloader;
import java.util.EventObject;

public class DownloadEvent
extends EventObject {
    public static final int DATA_TRANSFER = 1;
    public static final int DOWNLOAD_COMPLETE = 2;
    public static final int DOWNLOAD_PAUSED = 3;
    public static final int DOWNLOAD_RESUMED = 4;
    public static final int DOWNLOAD_FAILED = 5;
    public static final int DOWNLOAD_INIT = 6;
    public static final int DOWNLOAD_BEGUN = 7;
    public static final int DOWNLOAD_CANCELED = 8;
    protected int _action = 0;
    protected int _bytesTransferred = 0;
    protected long _totalBytesTransferred = 0L;
    protected long _expectedBytes = 0L;
    protected Exception _rootCause = null;
    protected long _startTime = 0L;
    protected long _endTime = 0L;
    protected String _urlStr = "";
    protected String _filename = "";
    protected String _name = "";
    protected long _timeStamp = System.currentTimeMillis();
    protected double _transferRate = 0.0;
    protected long _timeRemaining = -1L;
    protected Downloader _downloader;

    public DownloadEvent(Object source, int act) {
        this(source);
        this.setAction(act);
    }

    public DownloadEvent(Object source) {
        super(source);
    }

    void setAction(int act) {
        this._action = act;
    }

    public int getAction() {
        return this._action;
    }

    void setSource(Object source) {
        this.source = source;
    }

    public boolean isDataTransfer() {
        return this._action == 1;
    }

    void setStartTime(long t) {
        this._startTime = t;
    }

    public long getStartTime() {
        return this._startTime;
    }

    void setEndTime(long t) {
        this._endTime = t;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    void setExpectedBytes(long eb) {
        this._expectedBytes = eb;
    }

    public long getExpectedBytes() {
        return this._expectedBytes;
    }

    void setTotalBytesTransferred(long tb) {
        this._totalBytesTransferred = tb;
    }

    public long getTotalBytesTransferred() {
        return this._totalBytesTransferred;
    }

    void setBytesTransferred(int b) {
        this._bytesTransferred = b;
    }

    public int getBytesTransferred() {
        return this._bytesTransferred;
    }

    void setRootCause(Exception x) {
        this._rootCause = x;
    }

    public Exception getRootCause() {
        return this._rootCause;
    }

    void setFilename(String fn) {
        this._filename = fn;
    }

    public String getFilename() {
        return this._filename;
    }

    void setUrl(String url) {
        this._urlStr = url;
    }

    public String getUrl() {
        return this._urlStr;
    }

    void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setTransferRate(double tr) {
        this._transferRate = tr;
    }

    public double getTransferRate() {
        return this._transferRate;
    }

    public void setRemainingTime(long rt) {
        this._timeRemaining = rt;
    }

    public long getRemainingTime() {
        return this._timeRemaining;
    }

    public Downloader getDownloader() {
        return this._downloader;
    }

    public void setDownloader(Downloader downloader) {
        this._downloader = downloader;
    }

    @Override
    public String toString() {
        String desc;
        StringBuilder sb = new StringBuilder(500);
        sb.append("[");
        sb.append(DownloadEvent.class.toString());
        sb.append(" : ");
        switch (this._action) {
            case 2: {
                desc = "Complete";
                break;
            }
            case 3: {
                desc = "Paused";
                break;
            }
            case 4: {
                desc = "Resumed";
                break;
            }
            case 5: {
                desc = "Failed";
                break;
            }
            case 6: {
                desc = "Initialized";
                break;
            }
            case 7: {
                desc = "Begun";
                break;
            }
            case 1: {
                desc = "Transfer";
                break;
            }
            default: {
                desc = "Unknown";
            }
        }
        sb.append("type='").append(desc).append("'");
        sb.append(" timestamp='").append(this._timeStamp).append("'");
        sb.append(" name='").append(this._name).append("'");
        if (this._expectedBytes > -1L) {
            sb.append(" expected='").append(this._expectedBytes).append("'");
        } else {
            sb.append(" expected='unknown'");
        }
        sb.append(" total='").append(this._totalBytesTransferred).append("'");
        sb.append(" transferred='").append(this._bytesTransferred).append("'");
        sb.append(" start='").append(this._startTime).append("'");
        sb.append(" end='").append(this._endTime).append("'");
        if (this._rootCause != null) {
            sb.append(" cause='").append(this._rootCause).append("'");
        }
        sb.append("]");
        return sb.toString();
    }
}

