/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.jni;

import com.oracle.cie.common.util.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JNIUtil {
    private static Logger s_logger = Logger.getLogger(JNIUtil.class.getName());
    private static String cExtraPath = null;
    public static final String WIN32_SFX = "_win";
    public static final String WIN64_SFX = "_win64";
    public static final String WINX64_SFX = "_winx64";
    public static final String LINUX32_SFX = ".linux";
    public static final String LINUX64_SFX = ".linux64";
    public static final String AIX32_SFX = ".aix";
    public static final String SOL32_SFX = ".solaris";
    public static final String HPUX32_SFX = ".hpux";
    public static final String HPUX64_SFX = ".hpux64";

    public static native long getFreeSpace(String var0);

    public static native boolean setEcho(boolean var0);

    public static native int getConsoleWidth();

    public static native int getConsoleHeight();

    public static native String[] getUserList();

    public static native String[] getGroupList();

    public static native boolean isAdmin();

    public static native String getEnvVariable(String var0);

    public static native boolean setEnvVariable(String var0, String var1);

    public static native String[] getEnvBlock();

    public static native boolean createLocalNTUser(String var0, String var1, String var2);

    public static native boolean createLocalNTGroup(String var0, String var1);

    public static native boolean removeLocalNTUser(String var0);

    public static native boolean removeLocalNTGroup(String var0);

    public static native boolean setLocalNTUserAccountRights(String var0, String[] var1);

    public static native boolean setLocalNTGroupAccountRights(String var0, String[] var1);

    public static native boolean removeLocalNTUserAllAccountRights(String var0);

    public static native boolean removeLocalNTGroupAllAccountRights(String var0);

    public static native boolean addNTLocalGroupMember(String var0, String var1);

    public static native boolean isNTFS(String var0);

    public static native long getWinTotalMemory();

    public static native long getWinFreeMemory();

    public static native String getWinShortName(String var0);

    public static int getWinProcessorArch() {
        String s = JNIUtil.getEnvVariable("PROCESSOR_ARCHITECTURE");
        if (s == null) {
            return -1;
        }
        if (s.equalsIgnoreCase("x86")) {
            return 0;
        }
        if (s.equalsIgnoreCase("IA64")) {
            return 1;
        }
        return -1;
    }

    public static void loadLibrary(String lib) {
        try {
            System.load(JNIUtil.findLibrary(lib));
            return;
        }
        catch (UnsatisfiedLinkError ex1) {
            UnsatisfiedLinkError ex = ex1;
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String datamodel = System.getProperty("sun.arch.data.model");
            String suffix = null;
            if ("Linux".equals(os)) {
                if (arch.equals("x86") || "i386".equals(arch) || "i686".equals(arch)) {
                    suffix = LINUX32_SFX;
                }
                if ("ia64".equals(arch)) {
                    suffix = LINUX64_SFX;
                }
            } else if ("SunOS".equals(os) && "sparc".equals(arch) && "32".equals(datamodel)) {
                suffix = SOL32_SFX;
            } else if ("HP-UX".equals(os) && arch != null && arch.startsWith("PA_RISC") && "32".equals(datamodel)) {
                suffix = HPUX32_SFX;
            } else if ("HP-UX".equals(os) && arch != null && arch.startsWith("IA64N") && "32".equals(datamodel)) {
                suffix = HPUX64_SFX;
            } else if ("AIX".equals(os) && "ppc".equals(arch) && !"64".equals(datamodel)) {
                suffix = AIX32_SFX;
            } else if (os.startsWith("Windows")) {
                if ("x86".equals(arch)) {
                    suffix = WIN32_SFX;
                }
                if (arch.equals("ia64")) {
                    suffix = WIN64_SFX;
                }
                if (arch.equals("amd64") && datamodel.equals("64")) {
                    suffix = WINX64_SFX;
                }
            }
            if (suffix == null) {
                throw ex;
            }
            System.load(JNIUtil.findLibrary(lib + suffix));
            return;
        }
    }

    public static final String findLibrary(String libName) {
        File f = JNIUtil.findLibraryFile(libName);
        if (f == null) {
            if (s_logger.isLoggable(Level.FINE)) {
                s_logger.fine("Library '" + libName + "' not found.");
            }
            return libName;
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Library '" + libName + "' found at " + f);
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static final File findLibraryFile(String libName) {
        try {
            String l = System.mapLibraryName(libName);
            File f = new File(System.getProperty("user.dir") + File.separatorChar + l);
            if (f.exists()) {
                return f;
            }
            String libPath = System.getProperty("java.library.path");
            String[] array = libPath.split(File.pathSeparator);
            for (int i = 0; i < array.length; ++i) {
                f = new File(array[i] + File.separatorChar + l);
                if (!f.exists()) continue;
                return f;
            }
            URL u = JNIUtil.class.getClassLoader().getResource(l);
            if (u != null) {
                l = System.getProperty("os.name").startsWith("Win") ? u.getPath().substring(1).replaceAll("%20", " ") : u.getPath();
                return new File(l);
            }
            if (cExtraPath != null && (f = new File(cExtraPath + File.separator + l)).exists()) {
                return f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setExtraPath(String dir) {
        cExtraPath = dir;
        try {
            JNIUtil.loadLibrary("jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static native String[] listFileSystems();

    public static File[] listRoots() {
        int len;
        if (Platform.isWin()) {
            return File.listRoots();
        }
        String[] roots = JNIUtil.listFileSystems();
        if (roots == null || (len = roots.length) == 0) {
            return null;
        }
        File[] result = new File[len];
        for (int i = 0; i < len; ++i) {
            result[i] = new File(roots[i]);
        }
        return result;
    }

    public static native String getFileSystemRootPath(String var0);

    public static File getFileSystemRoot(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (IOException ioe) {
            path = path.getAbsoluteFile();
        }
        if (Platform.isWin()) {
            return new File(path.getAbsolutePath().substring(0, 3));
        }
        while (path != null && !path.exists()) {
            path = path.getParentFile();
        }
        if (path == null) {
            return null;
        }
        File root = null;
        String rootPath = JNIUtil.getFileSystemRootPath(path.getPath());
        if (rootPath != null) {
            root = new File(rootPath);
            try {
                root = root.getCanonicalFile();
            }
            catch (IOException ioe) {
                root = root.getAbsoluteFile();
            }
        }
        return root;
    }

    public static void main(String[] args) throws Exception {
        System.err.println("find library jni");
        System.err.println("result " + JNIUtil.findLibrary("jni"));
        System.err.println("Current free space: " + JNIUtil.getFreeSpace("."));
        System.err.println("Console width: " + JNIUtil.getConsoleWidth());
        System.err.println("Console height: " + JNIUtil.getConsoleHeight());
        if (args.length == 2) {
            ZipFile z = new ZipFile(args[0]){

                @Override
                protected void onInflate(long segSize) {
                    super.onInflate(segSize);
                    int p = (int)(this._currInflateSize * 100L / this._inflateSize);
                    System.err.println("Currently " + p + '%');
                }
            };
            System.err.println("size is " + z.getInflateSize());
            z.inflate(args[1]);
        }
    }

    static {
        try {
            JNIUtil.loadLibrary("jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static class ZipFile {
        protected File _zipFile;
        protected String _name;
        protected long _inflateSize;
        protected long _currInflateSize;

        public ZipFile(String fname) throws FileNotFoundException {
            this._zipFile = new File(fname);
            if (!this._zipFile.exists()) {
                throw new FileNotFoundException(fname);
            }
            this._name = this._zipFile.getAbsolutePath();
            try {
                this._name = this._zipFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public long getInflateSize() {
            return this.getInflateSize(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getInflateSize(String[] includes, String[] excludes) {
            Class<ZipFile> clazz = ZipFile.class;
            synchronized (ZipFile.class) {
                this._inflateSize = this.getInflateSize(this._name, includes, excludes);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this._inflateSize;
            }
        }

        public int inflate(String dir) {
            return this.inflate(dir, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int inflate(String dir, String[] includes, String[] excludes) {
            File d = new File(dir);
            if (d.exists() && !d.isDirectory()) {
                return -1;
            }
            if (!d.exists() && !d.mkdirs()) {
                return -1;
            }
            dir = d.getAbsolutePath();
            try {
                dir = d.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._currInflateSize = 0L;
            Class<ZipFile> clazz = ZipFile.class;
            synchronized (ZipFile.class) {
                int ret = this.inflate(this._name, dir, includes, excludes);
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return ret;
            }
        }

        protected void onInflate(long segSize, String fileName) {
            this.onInflate(segSize);
        }

        protected void onInflate(long segSize) {
            this._currInflateSize += segSize;
        }

        private native long getInflateSize(String var1, String[] var2, String[] var3);

        private native int inflate(String var1, String var2, String[] var3, String[] var4);

        public native void abort();

        static {
            JNIUtil.loadLibrary("jni");
        }
    }
}

