/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Locator;

public class SchemaWriter
implements XSVisitor,
XSSimpleTypeVisitor {
    private ArrayList<String> _schema = new ArrayList();
    private final Map<String, String> _namespaceMap = new LinkedHashMap<String, String>();
    private int _nsPrefixInt = 0;
    private int _indent;
    private XSSchema _xsSchema;
    private Collection<String> _importedNamespaces = new ArrayList<String>();

    public SchemaWriter(XSSchema s) {
        this._xsSchema = s;
        this.schema(s);
    }

    public void addImport(String namespace) {
        if (namespace != null && namespace.length() > 0 && !"http://www.w3.org/2001/XMLSchema".equals(namespace) && !this._importedNamespaces.contains(namespace)) {
            String systemId;
            Locator locator;
            String line = "<xs:import namespace=\"" + namespace + "\"";
            String schemaLocation = null;
            XSSchemaSet set = this._xsSchema.getRoot();
            XSSchema s = set.getSchema(namespace);
            if (s != null && (locator = s.getLocator()) != null && (systemId = locator.getSystemId()) != null && systemId.length() > 0) {
                int index = systemId.lastIndexOf("/");
                String string = schemaLocation = index > -1 ? systemId.substring(index + 1) : systemId;
            }
            if (schemaLocation != null) {
                line = line + " schemaLocation=\"" + schemaLocation + "\"";
            }
            line = line + "/>";
            int tmpIndent = this._indent;
            this._indent = 1;
            this.addLine(line, 0);
            this._indent = tmpIndent;
            this._importedNamespaces.add(namespace);
        }
    }

    private void addLine(String s) {
        this._schema.add(this.getIndentedLine(s));
    }

    private void addLine(String s, int index) {
        this._schema.add(index, this.getIndentedLine(s));
    }

    private String getIndentedLine(String s) {
        String line = "";
        for (int i = 0; i < this._indent; ++i) {
            line = line + "  ";
        }
        line = line + s;
        return line;
    }

    public void write(Writer writer) throws IOException {
        for (String line : this._schema) {
            writer.write(line);
            writer.write(10);
            writer.flush();
        }
    }

    public void schema(XSSchema s) {
        if (s.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        this._namespaceMap.put("http://www.w3.org/2001/XMLSchema", "xs");
        this.getNamspacePrefix(s.getTargetNamespace());
        ++this._indent;
        Iterator itr = s.iterateAttGroupDecls();
        while (itr.hasNext()) {
            this.attGroupDecl((XSAttGroupDecl)itr.next());
        }
        itr = s.iterateAttributeDecls();
        while (itr.hasNext()) {
            this.attributeDecl((XSAttributeDecl)itr.next());
        }
        itr = s.iterateComplexTypes();
        while (itr.hasNext()) {
            this.complexType((XSComplexType)itr.next());
        }
        itr = s.iterateElementDecls();
        while (itr.hasNext()) {
            this.elementDecl((XSElementDecl)itr.next());
        }
        itr = s.iterateModelGroupDecls();
        while (itr.hasNext()) {
            this.modelGroupDecl((XSModelGroupDecl)itr.next());
        }
        itr = s.iterateSimpleTypes();
        while (itr.hasNext()) {
            this.simpleType((XSSimpleType)itr.next());
        }
        --this._indent;
        String nsDecls = "";
        for (String namespace : this._namespaceMap.keySet()) {
            String prefix = this._namespaceMap.get(namespace);
            nsDecls = nsDecls + "xmlns:" + prefix + "=\"" + namespace + "\" ";
        }
        this.addLine("<xs:schema " + nsDecls + "targetNamespace=\"" + s.getTargetNamespace() + "\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">", 0);
        this.addLine("</xs:schema>");
    }

    public String getNamspacePrefix(String namespace) {
        String prefix = this._namespaceMap.get(namespace);
        if (prefix == null) {
            ++this._nsPrefixInt;
            prefix = "ns" + this._nsPrefixInt;
            this._namespaceMap.put(namespace, prefix);
        }
        if (!this._xsSchema.getTargetNamespace().equals(namespace)) {
            this.addImport(namespace);
        }
        return prefix;
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
        this.addLine(MessageFormat.format("<xs:attributeGroup name=\"{0}\">", decl.getName()));
        ++this._indent;
        Iterator itr = decl.iterateAttGroups();
        while (itr.hasNext()) {
            this.dumpRef((XSAttGroupDecl)itr.next());
        }
        itr = decl.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            this.attributeUse((XSAttributeUse)itr.next());
        }
        --this._indent;
        this.addLine("</xs:attributeGroup>");
    }

    public void dumpRef(XSAttGroupDecl decl) {
        this.addLine(MessageFormat.format("<xs:attributeGroup ref=\"{0}:{1}\"/>", this.getNamspacePrefix(decl.getTargetNamespace()), decl.getName()));
    }

    public void attributeUse(XSAttributeUse use) {
        XSAttributeDecl decl = use.getDecl();
        String additionalAtts = "";
        if (use.isRequired()) {
            additionalAtts = additionalAtts + " use=\"required\"";
        }
        if (use.getFixedValue() != null && use.getDecl().getFixedValue() == null) {
            additionalAtts = additionalAtts + " fixed=\"" + use.getFixedValue() + '\"';
        }
        if (use.getDefaultValue() != null && use.getDecl().getDefaultValue() == null) {
            additionalAtts = additionalAtts + " default=\"" + use.getDefaultValue() + '\"';
        }
        if (decl.isLocal()) {
            this.dump(decl, additionalAtts);
        } else {
            this.addLine(MessageFormat.format("<xs:attribute ref=\"{0}:{1}{2}\"/>", this.getNamspacePrefix(decl.getTargetNamespace()), decl.getName(), additionalAtts));
        }
    }

    public void attributeDecl(XSAttributeDecl decl) {
        this.dump(decl, "");
    }

    private void dump(XSAttributeDecl decl, String additionalAtts) {
        XSSimpleType type = decl.getType();
        this.addLine(MessageFormat.format("<xs:attribute name=\"{0}\"{1}{2}{3}{4}{5}>", decl.getName(), additionalAtts, type.isLocal() ? "" : MessageFormat.format(" type=\"{0}:{1}\"", this.getNamspacePrefix(type.getTargetNamespace()), type.getName()), decl.getFixedValue() == null ? "" : " fixed=\"" + decl.getFixedValue() + '\"', decl.getDefaultValue() == null ? "" : " default=\"" + decl.getDefaultValue() + '\"', type.isLocal() ? "" : " /"));
        if (type.isLocal()) {
            ++this._indent;
            this.simpleType(type);
            --this._indent;
            this.addLine("</xs:attribute>");
        }
    }

    public void simpleType(XSSimpleType type) {
        this.addLine(MessageFormat.format("<xs:simpleType{0}>", type.isLocal() ? "" : " name=\"" + type.getName() + '\"'));
        ++this._indent;
        type.visit((XSSimpleTypeVisitor)this);
        --this._indent;
        this.addLine("</xs:simpleType>");
    }

    public void listSimpleType(XSListSimpleType type) {
        XSSimpleType itemType = type.getItemType();
        if (itemType.isLocal()) {
            this.addLine("<xs:list>");
            ++this._indent;
            this.simpleType(itemType);
            --this._indent;
            this.addLine("</xs:list>");
        } else {
            this.addLine(MessageFormat.format("<xs:list itemType=\"{0}:{1}\" />", this.getNamspacePrefix(itemType.getTargetNamespace()), itemType.getName()));
        }
    }

    public void unionSimpleType(XSUnionSimpleType type) {
        XSSimpleType member;
        int i;
        int len = type.getMemberSize();
        StringBuffer ref = new StringBuffer();
        for (i = 0; i < len; ++i) {
            member = type.getMember(i);
            if (!member.isGlobal()) continue;
            ref.append(MessageFormat.format(" {0}:{1}", this.getNamspacePrefix(member.getTargetNamespace()), member.getName()));
        }
        if (ref.length() == 0) {
            this.addLine("<xs:union>");
        } else {
            this.addLine("<xs:union memberTypes=\"" + ref + "\">");
        }
        ++this._indent;
        for (i = 0; i < len; ++i) {
            member = type.getMember(i);
            if (!member.isLocal()) continue;
            this.simpleType(member);
        }
        --this._indent;
        this.addLine("</xs:union>");
    }

    public void restrictionSimpleType(XSRestrictionSimpleType type) {
        if (type.getBaseType() == null) {
            if (!type.getName().equals("anySimpleType")) {
                throw new InternalError();
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace())) {
                throw new InternalError();
            }
            return;
        }
        XSSimpleType baseType = type.getSimpleBaseType();
        this.addLine(MessageFormat.format("<xs:restriction{0}>", baseType.isLocal() ? "" : " base=\"" + this.getNamspacePrefix(baseType.getTargetNamespace()) + ':' + baseType.getName() + '\"'));
        ++this._indent;
        if (baseType.isLocal()) {
            this.simpleType(baseType);
        }
        Iterator itr = type.iterateDeclaredFacets();
        while (itr.hasNext()) {
            this.facet((XSFacet)itr.next());
        }
        --this._indent;
        this.addLine("</xs:restriction>");
    }

    public void facet(XSFacet facet) {
        this.addLine(MessageFormat.format("<xs:{0} value=\"{1}\"/>", facet.getName(), facet.getValue()));
    }

    public void notation(XSNotation notation) {
        this.addLine(MessageFormat.format("<xs:notation name='\"0}\" public =\"{1}\" system=\"{2}\" />", notation.getName(), notation.getPublicId(), notation.getSystemId()));
    }

    public void complexType(XSComplexType type) {
        this.addLine(MessageFormat.format("<xs:complexType{0}>", type.isLocal() ? "" : " name=\"" + type.getName() + '\"'));
        ++this._indent;
        if (type.getContentType().asSimpleType() != null) {
            this.addLine("<xs:simpleContent>");
            ++this._indent;
            XSType baseType = type.getBaseType();
            if (type.getDerivationMethod() == 2) {
                this.addLine(MessageFormat.format("<xs:restriction base=\"{0}:{1}\">", this.getNamspacePrefix(baseType.getTargetNamespace()), baseType.getName()));
                ++this._indent;
                this.dumpComplexTypeAttribute(type);
                --this._indent;
                this.addLine("</xs:restriction>");
            } else {
                this.addLine(MessageFormat.format("<xs:extension base=\"{0}:{1}\">", this.getNamspacePrefix(baseType.getTargetNamespace()), baseType.getName()));
                if (type.isGlobal() && type.getTargetNamespace().equals(baseType.getTargetNamespace()) && type.getName().equals(baseType.getName())) {
                    ++this._indent;
                    this.addLine("<xs:redefine>");
                    ++this._indent;
                    baseType.visit((XSVisitor)this);
                    --this._indent;
                    this.addLine("</xs:redefine>");
                    --this._indent;
                }
                ++this._indent;
                this.dumpComplexTypeAttribute(type);
                --this._indent;
                this.addLine("</xs:extension>");
            }
            --this._indent;
            this.addLine("</xs:simpleContent>");
        } else {
            XSComplexType baseType = type.getBaseType().asComplexType();
            if (type.getDerivationMethod() == 2) {
                if ("anyType".equals(baseType.getName())) {
                    type.getContentType().visit((XSVisitor)this);
                    this.dumpComplexTypeAttribute(type);
                } else {
                    this.addLine(MessageFormat.format("<xs:restriction base=\"{0}:{1}\">", this.getNamspacePrefix(baseType.getTargetNamespace()), baseType.getName()));
                    ++this._indent;
                    type.getContentType().visit((XSVisitor)this);
                    this.dumpComplexTypeAttribute(type);
                    --this._indent;
                    this.addLine("</xs:restriction>");
                }
            } else {
                this.addLine("<xs:complexContent>");
                ++this._indent;
                this.addLine(MessageFormat.format("<xs:extension base=\"{0}:{1}\">", this.getNamspacePrefix(baseType.getTargetNamespace()), baseType.getName()));
                if (type.isGlobal() && type.getTargetNamespace().equals(baseType.getTargetNamespace()) && type.getName().equals(baseType.getName())) {
                    ++this._indent;
                    this.addLine("<xs:redefine>");
                    ++this._indent;
                    baseType.visit((XSVisitor)this);
                    --this._indent;
                    this.addLine("</xs:redefine>");
                    --this._indent;
                }
                ++this._indent;
                XSContentType content = type.getExplicitContent();
                if (content != null) {
                    content.visit((XSVisitor)this);
                }
                this.dumpComplexTypeAttribute(type);
                --this._indent;
                this.addLine("</xs:extension>");
                --this._indent;
                this.addLine("</xs:complexContent>");
            }
        }
        --this._indent;
        this.addLine("</xs:complexType>");
    }

    private void dumpComplexTypeAttribute(XSComplexType type) {
        Iterator itr = type.iterateAttGroups();
        while (itr.hasNext()) {
            this.dumpRef((XSAttGroupDecl)itr.next());
        }
        itr = type.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            this.attributeUse((XSAttributeUse)itr.next());
        }
    }

    public void elementDecl(XSElementDecl decl) {
        this.elementDecl(decl, "");
    }

    private void elementDecl(XSElementDecl decl, String extraAtts) {
        XSElementDecl substitution;
        XmlString fixedValue;
        XSType type = decl.getType();
        List idConstraints = decl.getIdentityConstraints();
        boolean childContent = type.isLocal() || !idConstraints.isEmpty();
        XmlString defaultValue = decl.getDefaultValue();
        if (defaultValue != null) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " default=\"" + defaultValue + "\"";
        }
        if ((fixedValue = decl.getFixedValue()) != null) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " fixed=\"" + fixedValue + "\"";
        }
        if (decl.isNillable()) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " nillable=\"true\"";
        }
        if (decl.isAbstract()) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " abstract=\"true\"";
        }
        if ((substitution = decl.getSubstAffiliation()) != null) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " substitutionGroup=\"" + this.getNamspacePrefix(substitution.getTargetNamespace()) + ":" + substitution.getName() + "\"";
        }
        if (decl.isSubstitutionDisallowed(1)) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " block=\"extension\"";
        } else if (decl.isSubstitutionDisallowed(2)) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " block=\"restriction\"";
        } else if (decl.isSubstitutionDisallowed(4)) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " block=\"substitution\"";
        }
        if (decl.isSubstitutionExcluded(1)) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " final=\"extension\"";
        } else if (decl.isSubstitutionExcluded(2)) {
            extraAtts = (extraAtts != null ? extraAtts : "") + " final=\"restriction\"";
        }
        this.addLine(MessageFormat.format("<xs:element name=\"{0}\"{1}{2}{3}>", decl.getName(), type.isLocal() ? "" : " type=\"" + this.getNamspacePrefix(type.getTargetNamespace()) + ':' + type.getName() + '\"', extraAtts, childContent ? "" : "/"));
        if (type.isLocal()) {
            ++this._indent;
            if (type.isLocal()) {
                type.visit((XSVisitor)this);
            }
            --this._indent;
        }
        if (!idConstraints.isEmpty()) {
            ++this._indent;
            for (XSIdentityConstraint idConstraint : idConstraints) {
                this.identityConstraint(idConstraint);
            }
            --this._indent;
        }
        if (childContent) {
            this.addLine("</xs:element>");
        }
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
        this.addLine(MessageFormat.format("<xs:group name=\"{0}\">", decl.getName()));
        ++this._indent;
        this.modelGroup(decl.getModelGroup());
        --this._indent;
        this.addLine("</xs:group>");
    }

    public void modelGroup(XSModelGroup group) {
        this.modelGroup(group, "");
    }

    private void modelGroup(XSModelGroup group, String extraAtts) {
        this.addLine(MessageFormat.format("<xs:{0}{1}>", group.getCompositor(), extraAtts));
        ++this._indent;
        int len = group.getSize();
        for (int i = 0; i < len; ++i) {
            this.particle(group.getChild(i));
        }
        --this._indent;
        this.addLine(MessageFormat.format("</xs:{0}>", group.getCompositor()));
    }

    public void particle(XSParticle part) {
        StringBuffer buf = new StringBuffer();
        int i = this.getIntValue(part, "getMaxOccurs");
        if (i == -1) {
            buf.append(" maxOccurs=\"unbounded\"");
        } else if (i != 1) {
            buf.append(" maxOccurs=\"").append(i).append('\"');
        }
        i = this.getIntValue(part, "getMinOccurs");
        if (i != 1) {
            buf.append(" minOccurs=\"").append(i).append('\"');
        }
        final String extraAtts = buf.toString();
        part.getTerm().visit(new XSTermVisitor(){

            public void elementDecl(XSElementDecl decl) {
                if (decl.isLocal()) {
                    SchemaWriter.this.elementDecl(decl, extraAtts);
                } else {
                    SchemaWriter.this.addLine(MessageFormat.format("<xs:element ref=\"{0}:{1}\"{2}/>", SchemaWriter.this.getNamspacePrefix(decl.getTargetNamespace()), decl.getName(), extraAtts));
                }
            }

            public void modelGroupDecl(XSModelGroupDecl decl) {
                SchemaWriter.this.addLine(MessageFormat.format("<xs:group ref=\"{0}:{1}\"{2}/>", SchemaWriter.this.getNamspacePrefix(decl.getTargetNamespace()), decl.getName(), extraAtts));
            }

            public void modelGroup(XSModelGroup group) {
                SchemaWriter.this.modelGroup(group, extraAtts);
            }

            public void wildcard(XSWildcard wc) {
                SchemaWriter.this.wildcard(wc, extraAtts);
            }
        });
    }

    public void wildcard(XSWildcard wc) {
        this.wildcard(wc, "");
    }

    private void wildcard(XSWildcard wc, String extraAtts) {
        String processContents = "";
        switch (wc.getMode()) {
            case 1: {
                processContents = "lax";
                break;
            }
            case 2: {
                processContents = "strict";
                break;
            }
            case 3: {
                processContents = "skip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown processContents value: " + wc.getMode());
            }
        }
        this.addLine(MessageFormat.format("<xs:any processContents=\"{0}\"{1}/>", processContents, extraAtts));
    }

    public void annotation(XSAnnotation ann) {
    }

    public void identityConstraint(XSIdentityConstraint constraint) {
        List fields;
        String elementName;
        if (constraint.getCategory() == 0) {
            elementName = "key";
        } else if (constraint.getCategory() == 1) {
            elementName = "keyref";
        } else if (constraint.getCategory() == 2) {
            elementName = "unique";
        } else {
            throw new IllegalArgumentException("Unknown XSIdentityConstraint category " + constraint.getCategory());
        }
        this.addLine(MessageFormat.format("<xs:" + elementName + " name=\"{0}\"{1}>", constraint.getName(), constraint.getCategory() != 1 ? "" : " refer=\"" + this.getNamspacePrefix(constraint.getReferencedKey().getTargetNamespace()) + ':' + constraint.getReferencedKey().getName() + '\"'));
        XSXPath selector = constraint.getSelector();
        if (selector != null) {
            ++this._indent;
            this.addLine("<xs:selector xpath=\"" + this.replacedNamespacePrefixes(selector) + "\"/>");
            --this._indent;
        }
        if ((fields = constraint.getFields()) != null && !fields.isEmpty()) {
            ++this._indent;
            for (XSXPath field : fields) {
                this.addLine("<xs:field xpath=\"" + this.replacedNamespacePrefixes(field) + "\"/>");
            }
            --this._indent;
        }
        this.addLine("</xs:" + elementName + ">");
    }

    private String replacedNamespacePrefixes(XSXPath xsxpath) {
        String[] split;
        XmlString xpath = xsxpath.getXPath();
        String replaced = null;
        for (String ref : split = xpath.toString().split("/")) {
            int index = ref.indexOf(":");
            if (index > -1) {
                String oldPrefix = ref.substring(0, index);
                String namespace = xpath.resolvePrefix(oldPrefix);
                String newPrefix = this.getNamspacePrefix(namespace);
                ref = newPrefix + ref.substring(index);
            }
            replaced = replaced == null ? ref : replaced + "/" + ref;
        }
        return replaced;
    }

    public void xpath(XSXPath xp) {
    }

    public void empty(XSContentType t) {
    }

    private int getIntValue(Object object, String method) {
        int i = 0;
        if (object != null && method != null) {
            try {
                Object obj = object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
                i = obj instanceof BigInteger ? ((BigInteger)obj).intValue() : ((Integer)obj).intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return i;
    }
}

