/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.oracle.cie.common.dao.jaxb.SchemaWriter;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.xml.bind.v2.ContextFactory;
import com.sun.xml.xsom.XSSchema;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.xml.sax.ErrorHandler;

public class JaxbPackagingPlugin
extends Plugin {
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/comdev/plugin/jaxbPackagingPlugin";

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(NAMESPACE);
    }

    public String getOptionName() {
        return "Xpackaging";
    }

    public String getUsage() {
        return "  -Xpackaging      :  adds discoverable packaging information and schemas";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        File targetDir;
        String outputDir = System.getProperty("JaxbPackagingPlugin.output.dir");
        if (outputDir == null || outputDir.length() < 1) {
            System.out.println("Packaging Plugin -- Unable to determine output directory, please set \"JaxbPackagingPlugin.output.dir\" system property. Defaulting to target dir.");
            targetDir = opt.targetDir;
        } else {
            targetDir = new File(outputDir);
        }
        HashMap<String, Object> jaxbPackages = new HashMap<String, Object>();
        Iterable it = outline.getAllPackageContexts();
        for (Object schema : outline.getModel().schemaComponent.getSchemas()) {
            String targetNamespace = schema.getTargetNamespace();
            for (PackageOutline po : it) {
                String namespace = po.getMostUsedNamespaceURI();
                if (!targetNamespace.equals(namespace)) continue;
                String packageName = po._package().name();
                jaxbPackages.put(packageName, schema);
            }
        }
        Properties jaxbPackageProps = new Properties();
        for (String packageName : jaxbPackages.keySet()) {
            File packageDir;
            XSSchema schema = (XSSchema)jaxbPackages.get(packageName);
            String schemaLocation = schema.getLocator().getSystemId();
            String packagePath = packageName.replaceAll("\\.", "/");
            File jaxbPropertiesDir = packageDir = new File(targetDir, packagePath);
            String jaxbPropertiesDest = System.getProperty("JaxbPackagingPlugin.jaxb.properties.output.dir");
            if (jaxbPropertiesDest != null && !jaxbPropertiesDest.isEmpty()) {
                jaxbPropertiesDir = new File(jaxbPropertiesDest, packagePath);
                jaxbPropertiesDir.mkdirs();
            }
            File schemaSrc = new File(URI.create(schemaLocation));
            File schemaDest = new File(packageDir, schemaSrc.getName());
            packageDir.mkdirs();
            try {
                System.out.println("Packaging Plugin -- Saving schema originally from " + schemaSrc + " to " + schemaDest);
                SchemaWriter writer = new SchemaWriter(schema);
                FileWriter fw = new FileWriter(schemaDest);
                writer.write(fw);
                fw.close();
                String createProps = System.getProperty("JaxbPackagingPlugin.jaxb.properties");
                if (!"false".equalsIgnoreCase(createProps)) {
                    System.out.println("Packaging Plugin -- Writing jaxb.properties to directory " + jaxbPropertiesDir);
                    Properties jaxbProperties = new Properties();
                    jaxbProperties.setProperty("javax.xml.bind.context.factory", ContextFactory.class.getName());
                    fw = new FileWriter(new File(jaxbPropertiesDir, "jaxb.properties"));
                    jaxbProperties.store(fw, null);
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            jaxbPackageProps.setProperty(packageName, schemaDest.getName());
        }
        File jaxbPropertiesFile = new File(targetDir, "META-INF/com/oracle/cie/common/dao/jaxb/jaxb-packages.properties");
        System.out.println("Packaging Plugin -- Saving jaxb package properties to " + jaxbPropertiesFile);
        OutputStreamWriter fw = null;
        try {
            jaxbPropertiesFile.getParentFile().mkdirs();
            fw = new FileWriter(jaxbPropertiesFile);
            jaxbPackageProps.store(fw, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

