/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.PrePostVisitor;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeFilter;
import com.oracle.cie.common.comdev.TreeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class TreeHelper {
    public static Iterator getIterator(Tree t, TreeFilter filter) {
        return new TreeIterator(t, filter);
    }

    public static void depthFirstTraversal(Tree t, PrePostVisitor visitor) {
        TreeHelper.depthFirstTraversal(t, visitor, null);
    }

    public static void depthFirstTraversal(Tree t, PrePostVisitor visitor, TreeFilter filter) {
        if (visitor.isDone()) {
            return;
        }
        visitor.preVisit(t, filter);
        int degree = filter == null ? t.getDegree() : filter.getDegree(t);
        for (int i = 0; i < degree; ++i) {
            Tree child = filter == null ? t.getSubtree(i) : filter.getSubtree(t, i);
            TreeHelper.depthFirstTraversal(child, visitor, filter);
        }
        visitor.postVisit(t, filter);
    }

    public static void coDdepthFirstTraversal(Tree t1, Tree t2, PrePostVisitor visitor) {
        if (visitor.isDone()) {
            return;
        }
        visitor.preVisit(t1, t2);
        for (int i = 0; i < t1.getDegree(); ++i) {
            Tree c1 = t1.getSubtree(i);
            Tree c2 = t2.getSubtree(i);
            TreeHelper.coDdepthFirstTraversal(c1, c2, visitor);
        }
        visitor.postVisit(t1, t2);
    }

    public static void breadthFirstTraversal(Tree t, TreeVisitor visitor) {
        TreeHelper.breadthFirstTraversal(t, visitor, null);
    }

    public static void breadthFirstTraversal(Tree t, TreeVisitor visitor, TreeFilter filter) {
        LinkedList<Tree> queue = new LinkedList<Tree>();
        if (filter == null && !t.isLeaf() || filter != null && filter.isLeaf(t)) {
            queue.addLast(t);
        }
        while (!queue.isEmpty() && !visitor.isDone()) {
            Tree head = (Tree)queue.removeFirst();
            visitor.visitTree(head, filter);
            int degree = filter == null ? head.getDegree() : filter.getDegree(t);
            for (int i = 0; i < degree; ++i) {
                Tree child = filter == null ? head.getSubtree(i) : filter.getSubtree(head, i);
                queue.addLast(child);
            }
        }
    }

    public static Tree matchPath(Tree root, Tree[] path, Comparator comp, TreeFilter filter) {
        ArrayList paths = (ArrayList)TreeHelper.matchAllPaths(root, path, comp, filter);
        if (paths.size() == 0) {
            return null;
        }
        return (Tree)paths.get(0);
    }

    public static Collection matchAllPaths(Tree root, final Tree[] path, final Comparator comp, TreeFilter filter) {
        final ArrayList col = new ArrayList();
        TreeVisitor v = new TreeVisitor(){

            @Override
            public void visitTree(Tree t, TreeFilter filter) {
                if (comp.compare(t, path[0]) == 0) {
                    col.add(t);
                }
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        root.accept(v, filter);
        ArrayList parent = col;
        ArrayList<Tree> child = new ArrayList<Tree>();
        for (int i = 1; i < path.length; ++i) {
            for (Tree p : parent) {
                for (int j = 0; j < p.getDegree(); ++j) {
                    Tree c = p.getSubtree(j);
                    if (comp.compare(c, path[i]) != 0) continue;
                    child.add(c);
                }
            }
            ArrayList temp = parent;
            parent = child;
            child = temp;
            child.clear();
        }
        return parent;
    }

    static class TreeIterator
    implements Iterator {
        private Stack m_stack = new Stack();
        private TreeFilter m_filter;

        public TreeIterator(Tree t) {
            this(t, null);
        }

        public TreeIterator(Tree t, TreeFilter filter) {
            this.m_filter = filter;
            this.pushSubtrees(t);
        }

        @Override
        public boolean hasNext() {
            return !this.m_stack.empty();
        }

        public Object next() {
            Tree top = (Tree)this.m_stack.pop();
            this.pushSubtrees(top);
            return top;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TreeIterator");
        }

        private void pushSubtrees(Tree t) {
            int degree = this.m_filter == null ? t.getDegree() : this.m_filter.getDegree(t);
            for (int i = degree - 1; i >= 0; --i) {
                Tree child = this.m_filter == null ? t.getSubtree(i) : this.m_filter.getSubtree(t, i);
                this.m_stack.push(child);
            }
        }
    }
}

