/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.AttributeData;
import com.oracle.cie.common.comdev.Attributes;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreePrintVisitor;
import java.util.logging.Logger;

public class DebugTreePrinter
extends TreePrintVisitor {
    private Logger _log;

    public DebugTreePrinter(Tree root, Logger log) {
        super(root);
        this._log = log;
        this.setUseSpecialChar(false);
    }

    public DebugTreePrinter(Logger log) {
        this(null, log);
    }

    @Override
    public String getName(Tree currTree) {
        Object k;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTreeName(currTree));
        if (currTree.hasAttributes()) {
            Attributes attrs = currTree.getAttributes();
            Object[] keys = attrs.getKeys();
            Object[] values = attrs.getValues();
            sb.append(" [");
            for (int i = 0; i < keys.length; ++i) {
                sb.append(keys[i].toString()).append("=");
                sb.append(values[i]).append(", ");
            }
            sb.append("]");
        }
        if ((k = currTree.getKey()) instanceof AttributeData) {
            Attributes attrs = ((AttributeData)k).getAttributes();
            Object[] keys = attrs.getKeys();
            Object[] values = attrs.getValues();
            sb.append(" [");
            for (int i = 0; i < keys.length; ++i) {
                sb.append(keys[i].toString()).append("=");
                sb.append(values[i]).append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String getTreeName(Tree t) {
        return t.toString();
    }

    @Override
    protected void println(String s) {
        if (this._log != null) {
            this._log.fine(s);
        } else {
            this._out.println(s);
            this._out.flush();
        }
    }
}

