/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.carbdiff;

import com.oracle.cie.common.carbdiff.DependentDiff;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DependentDiffHandler {
    private Set<DependentDiff> _dependentDiffs = new HashSet<DependentDiff>();
    public static final String CLASS_EXTENSION = ".class";
    public static final String JAVA_EXTENSION = ".java";
    public static final String TSTAMP_EXTENSION = ".tstamp";

    public DependentDiffHandler() {
        this.init();
    }

    public void init() {
        this.addDependentDiff(".*/de/.*", ".*/de/.*-search/.*");
        this.addDependentDiff(".*/es/.*", ".*/es/.*-search/.*");
        this.addDependentDiff(".*/fr/.*", ".*/fr/.*-search/.*");
        this.addDependentDiff(".*/it/.*", ".*/it/.*-search/.*");
        this.addDependentDiff(".*/ja/.*", ".*/ja/.*-search/.*");
        this.addDependentDiff(".*/ko/.*", ".*/ko/.*-search/.*");
        this.addDependentDiff(".*/pt-br/.*", ".*/pt-br/.*-search/.*");
        this.addDependentDiff(".*/zh-cn/.*", ".*/zh-cn/.*-search/.*");
        this.addDependentDiff(".*/zh-tw/.*", ".*/zh-tw/.*-search/.*");
        this.addDependentDiff(".*/en-us/.*", ".*/en-us/.*-search/.*");
        this.addDependentDiff(".*", ".*/digest.properties");
        this.addDependentDiff(".*", ".*/signature.bin");
        this.addDependentDiff(".*", ".*/.*\\.tstamp");
    }

    public void addDependentDiff(String pathToVerify, String pathToInclude) {
        DependentDiff dependentDiff = new DependentDiff(pathToInclude, pathToVerify);
        this._dependentDiffs.add(dependentDiff);
    }

    public boolean includeOnlyIfChanged(String jarEntryName, Collection<String> entries) {
        boolean include = false;
        for (DependentDiff dependentDiff : this._dependentDiffs) {
            dependentDiff.verify(jarEntryName);
            if (!dependentDiff.matchEntry(jarEntryName) || entries != null && !entries.contains(jarEntryName.replaceFirst(TSTAMP_EXTENSION, JAVA_EXTENSION)) && !entries.contains(jarEntryName.replaceFirst(TSTAMP_EXTENSION, CLASS_EXTENSION))) continue;
            include = true;
        }
        return include;
    }

    public boolean verifyDependentEntry(String entry) {
        boolean matched = false;
        for (DependentDiff dependentDiff : this._dependentDiffs) {
            if (dependentDiff.matchEntry(entry)) {
                matched = true;
            }
            if (!dependentDiff.isVerified() || !dependentDiff.getIncludeEntries().contains(entry)) continue;
            return true;
        }
        return !matched;
    }

    public Set<String> getDependentEntries(Collection<String> diffEntries, Collection<String> rootJarEntries) {
        HashSet<String> verifiedDependentDiffs = new HashSet<String>();
        for (DependentDiff dependentDiff : this._dependentDiffs) {
            if (!dependentDiff.isVerified()) continue;
            for (String patchOnlyIfChangedEntryName : dependentDiff.getIncludeEntries()) {
                String javaEntry;
                if (rootJarEntries == null) continue;
                String classEntry = patchOnlyIfChangedEntryName.replaceFirst(TSTAMP_EXTENSION, CLASS_EXTENSION);
                if (rootJarEntries.contains(classEntry) && diffEntries.contains(classEntry)) {
                    verifiedDependentDiffs.add(classEntry);
                    verifiedDependentDiffs.add(patchOnlyIfChangedEntryName);
                }
                if (!rootJarEntries.contains(javaEntry = patchOnlyIfChangedEntryName.replaceFirst(TSTAMP_EXTENSION, JAVA_EXTENSION)) || !diffEntries.contains(javaEntry)) continue;
                verifiedDependentDiffs.add(javaEntry);
                verifiedDependentDiffs.add(patchOnlyIfChangedEntryName);
            }
        }
        return verifiedDependentDiffs;
    }
}

