/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.graph;

import com.oracle.cie.dependency.graph.DirectedEdge;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.GraphPrePostVisitor;
import com.oracle.cie.dependency.graph.GraphVisitor;
import com.oracle.cie.dependency.graph.Vertex;
import java.io.PrintStream;
import java.util.Arrays;

public class VisitorAdaptor<VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, G extends DirectedGraph<VK, V, EK, E>>
implements GraphVisitor<VK, V, EK, E, G>,
GraphPrePostVisitor<VK, V, EK, E, G> {
    public static final String IDENT = "    ";
    public static final String ACTION_MARKER = " \\-> ";
    protected boolean _traceVisited = Boolean.getBoolean("com.oracle.cie.dependency.graph.tracevisited");
    private PrintStream _traceOut;
    private int _depth;

    public VisitorAdaptor(PrintStream traceOut) {
        this._traceOut = traceOut;
        this._depth = -1;
    }

    @Override
    public void preOp(G graph) {
        this._depth = -1;
    }

    @Override
    public boolean visit(E edge, V vertex) {
        if (this._traceVisited) {
            this.trace(" --||| Visiting ", this.getVertexDescription(edge, vertex));
        }
        return true;
    }

    @Override
    public boolean preVisit(E edge, V vertex) {
        ++this._depth;
        if (this._traceVisited) {
            this.trace(" -->>> Before visiting ", this.getVertexDescription(edge, vertex));
        }
        return true;
    }

    @Override
    public void postVisit(E edge, V vertex) {
        if (this._traceVisited) {
            this.trace(" --<<< After visiting ", this.getVertexDescription(edge, vertex));
        }
        --this._depth;
    }

    @Override
    public void postOp(G graph) {
    }

    public int getDepth() {
        return this._depth;
    }

    protected void trace(Object ... args) {
        if (this._traceOut != null && args != null) {
            for (int i = 0; i < this._depth; ++i) {
                this._traceOut.append(IDENT);
            }
            for (Object arg : args) {
                this._traceOut.append(String.valueOf(arg));
            }
            this._traceOut.println();
        }
    }

    protected void traceAction(Object ... args) {
        if (this._traceOut != null && args != null) {
            Object[] arr = Arrays.copyOf(args, args.length + 1);
            System.arraycopy(arr, 0, arr, 1, args.length);
            arr[0] = ACTION_MARKER;
            this.trace(arr);
        }
    }

    protected String getVertexDescription(E edge, V vertex) {
        if (edge == null) {
            return "originating vertex [" + vertex + "]";
        }
        return "vertex [" + vertex + "] reached via edge [" + edge + "]";
    }
}

