/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.graph;

import com.oracle.cie.dependency.graph.DirectedEdge;
import com.oracle.cie.dependency.graph.EdgeFactory;
import com.oracle.cie.dependency.graph.Vertex;
import com.oracle.cie.dependency.graph.VertexFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DirectedGraph<VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>> {
    protected VertexFactory<VK, V> _vFactory;
    protected EdgeFactory<EK, V, E> _eFactory;
    protected Map<VK, VertexHolder<VK, V, EK, E>> _vMap;
    protected Map<EK, E> _eMap;

    public DirectedGraph(VertexFactory<VK, V> vFactory, EdgeFactory<EK, V, E> eFactory) {
        this._vFactory = vFactory;
        this._eFactory = eFactory;
        this._vMap = new HashMap<VK, VertexHolder<VK, V, EK, E>>();
        this._eMap = new HashMap<EK, E>();
    }

    public void replaceVertexKey(VK oldKey, VK newKey) {
        VertexHolder<VK, V, EK, E> v = this._vMap.remove(oldKey);
        this._vMap.put(newKey, v);
    }

    public V insertVertex(VK key) {
        V v = this._vFactory.createVertex(key);
        this._vMap.put(key, new VertexHolder(this, v));
        return v;
    }

    public V attachVertexFrom(V origin, VK vertexKey, EK edgeKey) {
        V dest = this.insertVertex(vertexKey);
        this.insertDirectedEdge(origin, dest, edgeKey);
        return dest;
    }

    public V attachVertexTo(V dest, VK vertexKey, EK edgeKey) {
        V origin = this.insertVertex(vertexKey);
        this.insertDirectedEdge(origin, dest, edgeKey);
        return origin;
    }

    public E insertDirectedEdge(V origin, V dest, EK key) {
        E e = this._eFactory.createEdge(origin, dest, key);
        VertexHolder<VK, V, EK, E> oh = this._vMap.get(origin.getKey());
        VertexHolder<VK, V, EK, E> dh = this._vMap.get(dest.getKey());
        oh.addOutgointEdge(e);
        dh.addIncomingEdge(e);
        this._eMap.put(key, e);
        return e;
    }

    public V removeVertex(VK key) {
        VertexHolder<VK, V, EK, E> h = this._vMap.remove(key);
        if (h == null) {
            return null;
        }
        for (DirectedEdge e : h.getAllEdges()) {
            this.removeEdge(e.getKey());
        }
        return h.getVertex();
    }

    public E removeEdge(EK key) {
        VertexHolder<VK, V, EK, DirectedEdge> dh;
        DirectedEdge e = (DirectedEdge)this._eMap.remove(key);
        if (e == null) {
            return null;
        }
        VertexHolder<VK, V, EK, DirectedEdge> oh = this._vMap.get(((Vertex)e.getSource()).getKey());
        if (oh != null) {
            oh.removeOutgointEdge(e);
        }
        if ((dh = this._vMap.get(((Vertex)e.getDest()).getKey())) != null) {
            dh.removeIncomingEdge(e);
        }
        return (E)e;
    }

    public List<E> getIncomingEdges(V v) {
        VertexHolder<VK, V, EK, E> h = this._vMap.get(v.getKey());
        if (h == null) {
            return Collections.emptyList();
        }
        return h.getIncomingEdges();
    }

    public List<E> getOutgoingEdges(V v) {
        VertexHolder<VK, V, EK, E> h = this._vMap.get(v.getKey());
        if (h == null) {
            return Collections.emptyList();
        }
        return h.getOutgoingEdges();
    }

    public List<V> getIncomingVertices(V v) {
        VertexHolder<VK, V, EK, E> h = this._vMap.get(v.getKey());
        if (h == null) {
            return Collections.emptyList();
        }
        return h.getIncomingVertices();
    }

    public List<V> getOutgoingVertices(V v) {
        VertexHolder<VK, V, EK, E> h = this._vMap.get(v.getKey());
        if (h == null) {
            return Collections.emptyList();
        }
        return h.getOutgoingVertices();
    }

    public int getNumberOfEdges() {
        return this._eMap.size();
    }

    public int getNumberOfVertices() {
        return this._vMap.size();
    }

    public V getVertex(VK key) {
        VertexHolder<VK, V, EK, E> h = this._vMap.get(key);
        return h == null ? null : (V)h.getVertex();
    }

    public E getEdge(EK key) {
        return (E)((DirectedEdge)this._eMap.get(key));
    }

    public List<V> getVertices() {
        ArrayList<V> vList = new ArrayList<V>();
        for (VertexHolder<VK, V, EK, E> h : this._vMap.values()) {
            vList.add(h.getVertex());
        }
        return vList;
    }

    public List<E> getEdges() {
        return new ArrayList<E>(this._eMap.values());
    }

    public boolean isDirected() {
        return true;
    }

    public static class VertexHolder<VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>> {
        V _vertex;
        List<E> _incomingEdges;
        List<E> _outgoingEdges;
        List<V> _incomingVertices;
        List<V> _outgoingVertices;
        final /* synthetic */ DirectedGraph this$0;

        public VertexHolder(V vertex) {
            this.this$0 = this$0;
            this._vertex = vertex;
            this._incomingEdges = new ArrayList();
            this._outgoingEdges = new ArrayList();
            this._incomingVertices = new ArrayList<V>();
            this._outgoingVertices = new ArrayList<V>();
        }

        public V getVertex() {
            return this._vertex;
        }

        public List<E> getAllEdges() {
            ArrayList<E> list = new ArrayList<E>(this._incomingEdges);
            list.addAll(this._outgoingEdges);
            return list;
        }

        public List<E> getIncomingEdges() {
            return this._incomingEdges;
        }

        public List<E> getOutgoingEdges() {
            return this._outgoingEdges;
        }

        public List<V> getAllVertices() {
            HashSet<V> set = new HashSet<V>(this._incomingVertices);
            set.addAll(this._outgoingVertices);
            return new ArrayList<V>(set);
        }

        public List<V> getIncomingVertices() {
            return this._incomingVertices;
        }

        public List<V> getOutgoingVertices() {
            return this._outgoingVertices;
        }

        public void addOutgointEdge(E e) {
            this._outgoingEdges.add(e);
            this._outgoingVertices.add(e.getDest());
        }

        public void addIncomingEdge(E e) {
            this._incomingEdges.add(e);
            this._incomingVertices.add(e.getSource());
        }

        public void removeOutgointEdge(E e) {
            if (this._outgoingEdges.remove(e)) {
                this._outgoingVertices.remove(e.getDest());
            }
        }

        public void removeIncomingEdge(E e) {
            if (this._incomingEdges.remove(e)) {
                this._incomingVertices.remove(e.getDest());
            }
        }
    }
}

