/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class UncondPrereqsSelector
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private SortedMap<Integer, List<TVertex>> _unresolvedOrs;
    private List<TVertex> _selectionsWhichWerePrevioslyConflicts;
    private List<TVertex> _conflictsWhichWerePrevioslySelected;
    private List<TVertex> _selCondInstConflicts;
    private List<TVertex> _conflCondInstConflicts;
    private List<TVertex> _unresolvedPrereqsErr;
    private List<TVertex> _selfConflictsErr;
    private List<TVertex> _prereqsConflictingWithInstalledErr;
    private List<TVertex> _installedConflictsErr;

    public UncondPrereqsSelector(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
        this._unresolvedOrs = new TreeMap<Integer, List<TVertex>>();
        this._selectionsWhichWerePrevioslyConflicts = new ArrayList<TVertex>();
        this._conflictsWhichWerePrevioslySelected = new ArrayList<TVertex>();
        this._selCondInstConflicts = new ArrayList<TVertex>();
        this._conflCondInstConflicts = new ArrayList<TVertex>();
        this._unresolvedPrereqsErr = new ArrayList<TVertex>();
        this._selfConflictsErr = new ArrayList<TVertex>();
        this._prereqsConflictingWithInstalledErr = new ArrayList<TVertex>();
        this._installedConflictsErr = new ArrayList<TVertex>();
    }

    public List<TVertex> getUnresolvedOrs() {
        ArrayList<TVertex> list = new ArrayList<TVertex>();
        for (List<TVertex> l : this._unresolvedOrs.values()) {
            list.addAll(l);
        }
        return list;
    }

    public List<TVertex> getSelectionsWhichWerePrevioslyConflicts() {
        return this._selectionsWhichWerePrevioslyConflicts;
    }

    public List<TVertex> getConflictsWhichWerePrevioslySelected() {
        return this._conflictsWhichWerePrevioslySelected;
    }

    public List<TVertex> getSelCondInstConflicts() {
        return this._selCondInstConflicts;
    }

    public List<TVertex> getConflCondInstConflicts() {
        return this._conflCondInstConflicts;
    }

    public List<TVertex> getUnresolvedPrereqsErr() {
        return this._unresolvedPrereqsErr;
    }

    public List<TVertex> getSelfConflictsErr() {
        return this._selfConflictsErr;
    }

    public List<TVertex> getPrereqsConflictingWithInstalledErr() {
        return this._prereqsConflictingWithInstalledErr;
    }

    public List<TVertex> getInstalledConflictsErr() {
        return this._installedConflictsErr;
    }

    public boolean hasErrors() {
        return !this._unresolvedPrereqsErr.isEmpty() || !this._selfConflictsErr.isEmpty() || !this._prereqsConflictingWithInstalledErr.isEmpty() || !this._installedConflictsErr.isEmpty();
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._unresolvedOrs.clear();
        this._selectionsWhichWerePrevioslyConflicts.clear();
        this._conflictsWhichWerePrevioslySelected.clear();
        this._selCondInstConflicts.clear();
        this._conflCondInstConflicts.clear();
        this._unresolvedPrereqsErr.clear();
        this._selfConflictsErr.clear();
        this._prereqsConflictingWithInstalledErr.clear();
        this._installedConflictsErr.clear();
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        boolean traverseChildren = false;
        if (edge != null && ((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            this.trace("PROCESSING CONFLICT <", vertex, "> which conflicts with <", edge.getSource(), ">");
            this.markConflict(vertex);
        } else if (vKey.getType() == VKey.VType.OR_COND) {
            ArrayList<TVertex> orList = (ArrayList<TVertex>)this._unresolvedOrs.get(this.getDepth());
            if (orList == null) {
                orList = new ArrayList<TVertex>();
                this._unresolvedOrs.put(this.getDepth(), orList);
            }
            orList.add(vertex);
            this.trace("KEEPING unresolved OR <", vertex, ">");
        } else {
            if (edge == null) {
                this.trace("SELECTING PREREQUISITES FOR <", vertex, ">");
            } else {
                this.trace("PROCESSING PREREQUISITE <", vertex, "> which is required by <" + edge.getSource(), ">");
            }
            boolean wasSelected = vKey.getSelectedState() == VKey.SelectedState.SELECTED;
            this.selectPrerequisite(vertex);
            if (vKey.getType() != VKey.VType.TINFO || vKey.getInstalledState() != VKey.InstalledState.INSTALLED && !wasSelected) {
                traverseChildren = true;
            }
        }
        return traverseChildren;
    }

    private void selectPrerequisite(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() == VKey.VType.UNRESOLVED) {
            this.traceAction("ERROR: found unresolved prerequisite ", vKey);
            this._unresolvedPrereqsErr.add(vertex);
            return;
        }
        switch (vKey.getSelectedState()) {
            case NOTSELECTED: {
                switch (vKey.getInstalledState()) {
                    case INSTALLED: {
                        this.traceAction("NOACTION: prerequisite is already installed ", vKey);
                        break;
                    }
                    case CONFLICTS_WITH_INSTALLED: {
                        this.traceAction("ERROR: vertex conflicts with installed items ", vKey);
                        this._prereqsConflictingWithInstalledErr.add(vertex);
                        break;
                    }
                    case COND_CONFL: {
                        this._selCondInstConflicts.add(vertex);
                    }
                    case NOTINSTALLED: {
                        this.traceAction("SELECT: ", vKey);
                        vKey.setSelectedState(VKey.SelectedState.SELECTED);
                    }
                }
                break;
            }
            case SELECTED: {
                if (vKey.wasStateSetInOp()) {
                    this.traceAction("NOACTION: already selected in this session ", vKey);
                    break;
                }
                this.traceAction("SELECT: prerequisite selected in prior operation ", vKey);
                vKey.setSelectedState(VKey.SelectedState.SELECTED);
                break;
            }
            case CONFLICTS: {
                if (vKey.wasStateSetInOp()) {
                    this.traceAction("ERROR: invalid dependency; vertex is required by and conflicts with the selection ", vKey);
                    if (this._selfConflictsErr.contains(vertex)) break;
                    this._selfConflictsErr.add(vertex);
                    break;
                }
                this.traceAction("SELECT-OVERRIDE: selecting previously marked conflict ", vKey);
                this._selectionsWhichWerePrevioslyConflicts.add(vertex);
                vKey.setSelectedState(VKey.SelectedState.SELECTED);
            }
        }
    }

    private void markConflict(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.TINFO || vKey.getType() == VKey.VType.UNRESOLVED);
        if (vKey.getType() == VKey.VType.UNRESOLVED) {
            this.traceAction("MARK_CONFLICT: marking unresolved vertex ", vKey);
            vKey.setSelectedState(VKey.SelectedState.CONFLICTS);
            return;
        }
        switch (vKey.getSelectedState()) {
            case NOTSELECTED: {
                switch (vKey.getInstalledState()) {
                    case INSTALLED: {
                        this.traceAction("ERROR: a conflicting vertex is already installed ", vKey);
                        this._installedConflictsErr.add(vertex);
                        break;
                    }
                    case CONFLICTS_WITH_INSTALLED: {
                        this.traceAction("NOACTION: vertex already conflicts with some of the installed vertices ", vKey);
                        break;
                    }
                    case COND_CONFL: {
                        this._conflCondInstConflicts.add(vertex);
                    }
                    case NOTINSTALLED: {
                        this.traceAction("MARK_CONFLICT: marking not selected vertex as conflict ", vKey);
                        vKey.setSelectedState(VKey.SelectedState.CONFLICTS);
                    }
                }
                break;
            }
            case SELECTED: {
                if (vKey.wasStateSetInOp()) {
                    this.traceAction("ERROR: invalid dependency. Vertex is required and conflicts with the selection ", vKey);
                    if (this._selfConflictsErr.contains(vertex)) break;
                    this._selfConflictsErr.add(vertex);
                    break;
                }
                this.traceAction("MARK_CONFLICT-OVERRIDE: Marking previously selected vertex as conflict ", vKey);
                this._conflictsWhichWerePrevioslySelected.add(vertex);
                vKey.setSelectedState(VKey.SelectedState.CONFLICTS);
                break;
            }
            case CONFLICTS: {
                if (vKey.wasStateSetInOp()) {
                    this.traceAction("NOACTION: vertex already marked as conflict in this session ", vKey);
                    break;
                }
                this.traceAction("MARK_CONFLICT: marking vertex conflicting with the existing selection as conflict ", vKey);
                vKey.setSelectedState(VKey.SelectedState.CONFLICTS);
            }
        }
    }
}

