/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.EdgeFilter;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PrerequisitesSorter
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>>
implements EdgeFilter<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private List<TVertex> _reversePrereqsList = new ArrayList<TVertex>();

    PrerequisitesSorter(PrintStream traceOut) {
        super(traceOut);
    }

    public List<TVertex> getReversePrereqsList() {
        return new ArrayList<TVertex>(this._reversePrereqsList);
    }

    public List<TVertex> getDirectPrereqsList() {
        List<TVertex> list = this.getReversePrereqsList();
        Collections.reverse(list);
        return list;
    }

    @Override
    public List<TEdge> filter(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex, List<TEdge> edges) {
        ArrayList<TEdge> filtered = new ArrayList<TEdge>();
        for (TEdge edge : edges) {
            if (((EKey)edge.getKey()).getType() != EKey.EType.REQUIRES) continue;
            filtered.add(edge);
        }
        return filtered;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        this._reversePrereqsList.clear();
    }

    @Override
    public void postVisit(TEdge edge, TVertex vertex) {
        super.postVisit(edge, vertex);
        assert (edge == null || ((EKey)edge.getKey()).getType() == EKey.EType.REQUIRES);
        if (((VKey)vertex.getKey()).getType() == VKey.VType.TINFO) {
            this._reversePrereqsList.add(vertex);
        }
    }
}

