/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;

class ExtSelectabilityDetector
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private boolean _reachableFromExtSelectable;

    ExtSelectabilityDetector(PrintStream traceOut) {
        super(traceOut);
    }

    public boolean isReachableFromExtSelectable() {
        return this._reachableFromExtSelectable;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        this._reachableFromExtSelectable = false;
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (edge == null) {
            this.trace("DETECTING IF VERTEX IS AN ORFAN <", vertex, ">");
        } else {
            this.trace("PROCESSING VERTEX <", vertex, "> reached from <" + edge.getDest(), ">");
        }
        if (this._reachableFromExtSelectable) {
            this.traceAction("NOACTION: Externally selectable vertex was already detected");
            return false;
        }
        if (edge != null && ((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS || vKey.getSelectedState() != VKey.SelectedState.SELECTED) {
            this.traceAction("NOACTION: the vertex is not selected or is a conflict ", vKey);
            return false;
        }
        if (vKey.isExtSelectable()) {
            this.traceAction("FOUND: found user-selectable vertex which is selected ", vKey, "; the originating vertex should stay selected");
            this._reachableFromExtSelectable = true;
            return false;
        }
        this.traceAction("NOACTION: intermediate or not extrernally selectable vertex ", vKey);
        return true;
    }
}

