/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;

class ConditionMarker
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;

    public ConditionMarker(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        VKey vKey;
        super.preVisit(edge, vertex);
        if (edge == null) {
            this.trace("DETERMING OR RESOLVABILITY <", vertex, ">");
        }
        return ((vKey = (VKey)vertex.getKey()).getType() == VKey.VType.AND_COND || vKey.getType() == VKey.VType.OR_COND) && ConditionHelper.hasCondPrereqs(this._graph, vertex);
    }

    @Override
    public void postVisit(TEdge edge, TVertex vertex) {
        super.postVisit(edge, vertex);
        if (edge == null) {
            this.trace("DETERMINING OR RESOLVABILITY <", vertex, ">");
        } else {
            this.trace("PROCESSING <", vertex, "> reached from <", edge.getSource(), ">");
        }
        VKey vKey = (VKey)vertex.getKey();
        switch (vKey.getType()) {
            case AND_COND: {
                this.setCondAndVertexSelState(vertex);
                break;
            }
            case OR_COND: {
                this.setCondOrVertexSelState(vertex);
                break;
            }
            default: {
                this.traceAction("NOACTION: vertex is not a condition ", vKey);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setCondAndVertexSelState(TVertex vertex) {
        vKey = (VKey)vertex.getKey();
        if (!ConditionMarker.$assertionsDisabled && vKey.getType() != VKey.VType.AND_COND) {
            throw new AssertionError();
        }
        andState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
lbl5:
        // 5 sources

        block22: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            block31: {
                outV = (TVertex)outEdge.getDest();
                outVKey = (VKey)outV.getKey();
                if (((EKey)outEdge.getKey()).getType() != EKey.EType.CONFLICTS) break block31;
                if (!ConditionMarker.$assertionsDisabled && outVKey.getType() != VKey.VType.TINFO && outVKey.getType() != VKey.VType.UNRESOLVED) {
                    throw new AssertionError();
                }
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    this.traceAction(new Object[]{"...CONTINUE... Found conflict with UNRESOLVED vertex which holds by its nature " + outVKey});
                    continue;
                }
                block0 : switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$SelectedState[outVKey.getSelectedState().ordinal()]) {
                    case 1: {
                        if (outVKey.wasStateSetInOp()) {
                            this.traceAction(new Object[]{"...STOP... Found conflict which was selected in the current session ", outVKey});
                            andState = VKey.SelectedState.NOTSELECTED;
                            break block22;
                        }
                        this.traceAction(new Object[]{"...CONTINUE... Found conflict selected during prior sessions; treat as conflict candidate ", outVKey});
                        if (andState != VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE) {
                            andState = VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE;
                            break;
                        }
                        ** GOTO lbl5
                    }
                    case 2: {
                        this.traceAction(new Object[]{"...CONTINUE... Found conflict which is already marked ", outVKey});
                        break;
                    }
                    case 3: {
                        switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$InstalledState[outVKey.getInstalledState().ordinal()]) {
                            case 1: {
                                this.traceAction(new Object[]{"...STOP... Found installed conflict " + outVKey});
                                andState = VKey.SelectedState.NOTSELECTED;
                                break block22;
                            }
                            case 2: {
                                this.traceAction(new Object[]{"...CONTINUE... Found conflict which confclicts with installed items ", outVKey});
                                break block0;
                            }
                            case 3: 
                            case 4: {
                                this.traceAction(new Object[]{"...CONTINUE... Found not installed and not selected conflict. Will be marked by condition finalizer ", outVKey});
                            }
                        }
                    }
                }
                continue;
            }
            switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$SelectedState[outVKey.getSelectedState().ordinal()]) {
                case 1: 
                case 4: {
                    this.traceAction(new Object[]{"...CONTINUE... Found selected or resolved prerequisite ", outVKey});
                    ** GOTO lbl81
                }
                case 5: {
                    this.traceAction(new Object[]{"...CONTINUE... Found resolvable prerequisite ", outVKey});
                    if (andState == VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE) ** GOTO lbl81
                    andState = VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE;
                    ** GOTO lbl81
                }
                case 6: {
                    this.traceAction(new Object[]{"...CONTINUE... Found possibly resolvable prerequisite ", outVKey});
                    andState = VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                    ** GOTO lbl81
                }
                case 2: {
                    if (outVKey.wasStateSetInOp()) {
                        this.traceAction(new Object[]{"...STOP... Found prerequisite marked as conflict in the current session ", outVKey});
                        andState = VKey.SelectedState.NOTSELECTED;
                        break block22;
                    }
                    this.traceAction(new Object[]{"...CONTINUE... Found prerequisite marked as conflict in prior sessions; treat as selection candidate ", outVKey});
                    if (andState == VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE) ** GOTO lbl81
                    andState = VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE;
                    ** GOTO lbl81
                }
                case 3: {
                    if (outVKey.getType() == VKey.VType.TINFO) {
                        switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$InstalledState[outVKey.getInstalledState().ordinal()]) {
                            case 1: {
                                this.traceAction(new Object[]{"...CONTINUE... Found already installed prerequisite ", outVKey});
                                break;
                            }
                            case 2: {
                                this.traceAction(new Object[]{"...STOP... Found prerequisite which is marked as conflict with installed items ", outVKey});
                                andState = VKey.SelectedState.NOTSELECTED;
                                break block22;
                            }
                            case 3: 
                            case 4: {
                                this.traceAction(new Object[]{"...CONTINUE... Found not selected prerequisite; treat as selection candidate ", outVKey});
                                if (andState == VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE) break;
                                andState = VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE;
                            }
                        }
                    } else {
                        this.traceAction(new Object[]{"...STOP... Found unresolved prerequisite ", outVKey});
                        andState = VKey.SelectedState.NOTSELECTED;
                        break block22;
                    }
                }
lbl81:
                // 8 sources

                default: {
                    continue block22;
                }
            }
        }
        vKey.setSelectedState(andState);
        this.traceAction(new Object[]{"DETERMINED <AND> STATE ", vKey});
    }

    /*
     * Unable to fully structure code
     */
    private void setCondOrVertexSelState(TVertex vertex) {
        vKey = (VKey)vertex.getKey();
        if (!ConditionMarker.$assertionsDisabled && vKey.getType() != VKey.VType.OR_COND) {
            throw new AssertionError();
        }
        resolver = ((VKey)vertex.getKey()).getResolver();
        if (resolver != null) {
            resolver.reset();
        }
        orState = VKey.SelectedState.NOTSELECTED;
lbl8:
        // 4 sources

        block22: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            block37: {
                outV = (TVertex)outEdge.getDest();
                outVKey = (VKey)outV.getKey();
                if (((EKey)outEdge.getKey()).getType() != EKey.EType.CONFLICTS) break block37;
                if (!ConditionMarker.$assertionsDisabled && outVKey.getType() != VKey.VType.TINFO && outVKey.getType() != VKey.VType.UNRESOLVED) {
                    throw new AssertionError();
                }
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    this.traceAction(new Object[]{"...STOP... Found conflict with UNRESOLVED vertex which holds by its nature ", outVKey});
                    orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                    break;
                }
                block0 : switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$SelectedState[outVKey.getSelectedState().ordinal()]) {
                    case 1: {
                        if (outVKey.wasStateSetInOp()) {
                            this.traceAction(new Object[]{"...CONTINUE... Found conflict which is selected in the current session ", outVKey});
                            break;
                        }
                        this.traceAction(new Object[]{"...CONTINUE... Found conflict which was selected during prior sessions; treat as candidate for reversal ", outVKey});
                        orState = orState == VKey.SelectedState.NOTSELECTED ? VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE : VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                        if (resolver != null) {
                            resolver.addCandidate(outEdge);
                            break;
                        }
                        ** GOTO lbl8
                    }
                    case 2: {
                        this.traceAction(new Object[]{"...STOP... Found already marked conflict ", outVKey});
                        orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                        break block22;
                    }
                    case 3: {
                        switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$InstalledState[outVKey.getInstalledState().ordinal()]) {
                            case 1: {
                                this.traceAction(new Object[]{"...CONTINUE... Found installed conflict ", outVKey});
                                break block0;
                            }
                            case 2: {
                                this.traceAction(new Object[]{"...STOP... Found conflict which already confclicts with installed items ", outVKey});
                                orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                                break block22;
                            }
                            case 3: 
                            case 4: {
                                this.traceAction(new Object[]{"...STOP... Found conflict whitch is not selected ", outVKey});
                                orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                                break block22;
                            }
                        }
                    }
                }
                continue;
            }
            switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$SelectedState[outVKey.getSelectedState().ordinal()]) {
                case 1: 
                case 4: {
                    this.traceAction(new Object[]{"...STOP... Found selected or resolved prerequisite ", outVKey});
                    orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                    break block22;
                }
                case 5: {
                    this.traceAction(new Object[]{"...CONTINUE... Found resolvable prerequisite ", outVKey});
                    orState = orState == VKey.SelectedState.NOTSELECTED ? VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE : VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                    if (resolver != null) {
                        resolver.addCandidate(outEdge);
                    }
                    ** GOTO lbl91
                }
                case 6: {
                    this.traceAction(new Object[]{"...CONTINUE... Found possibly resolvable prerequisite ", outVKey});
                    orState = VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                    if (resolver != null) {
                        resolver.addCandidate(outEdge);
                    }
                    ** GOTO lbl91
                }
                case 2: {
                    if (outVKey.wasStateSetInOp()) {
                        this.traceAction(new Object[]{"...CONTINUE... Found prerequisite marked as conflict in the current session ", outVKey});
                    } else {
                        this.traceAction(new Object[]{"...CONTINUE... Found prerequisite which was marked as conflict in prior sessions; treat as candidate for selection ", outVKey});
                        orState = orState == VKey.SelectedState.NOTSELECTED ? VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE : VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                        if (resolver != null) {
                            resolver.addCandidate(outEdge);
                        }
                    }
                    ** GOTO lbl91
                }
                case 3: {
                    if (outVKey.getType() == VKey.VType.TINFO) {
                        switch (1.$SwitchMap$com$oracle$cie$dependency$VKey$InstalledState[outVKey.getInstalledState().ordinal()]) {
                            case 1: {
                                this.traceAction(new Object[]{"...STOP... Found installed prerequisite ", outVKey});
                                orState = VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE;
                                break block22;
                            }
                            case 2: {
                                this.traceAction(new Object[]{"...CONTINUE... Found prerequisite marked as conflict with installed items ", outVKey});
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.traceAction(new Object[]{"...CONTINUE... Found not selected prerequisite; treat as candidate for selection ", outVKey});
                                orState = orState == VKey.SelectedState.NOTSELECTED ? VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE : VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE;
                                if (resolver == null) break;
                                resolver.addCandidate(outEdge);
                            }
                        }
                    } else {
                        this.traceAction(new Object[]{"...CONTINUE... Found unresolved prerequisite ", outVKey});
                    }
                }
lbl91:
                // 7 sources

                default: {
                    continue block22;
                }
            }
        }
        if (orState == VKey.SelectedState.POSSIBLE_SELECTION_CANDIDATE && resolver != null && resolver.isResolvable()) {
            orState = VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE;
            this.traceAction(new Object[]{"...RESOLVING WITH RESOLVER..."});
        }
        vKey.setSelectedState(orState);
        this.traceAction(new Object[]{"DETERMINED <OR> STATE ", vKey});
    }
}

