/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.transform.SecuritySupport;
import javax.xml.transform.TransformerFactoryConfigurationError;

class FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xalan.internal.";
    private static boolean debug = false;
    private static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;
    private static final SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    private static Class<?> getProviderClass(String className, ClassLoader cl, boolean doFallback, boolean useBSClsLoader) throws ClassNotFoundException {
        try {
            if (cl == null) {
                if (useBSClsLoader) {
                    return Class.forName(className, false, FactoryFinder.class.getClassLoader());
                }
                cl = ss.getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException();
                }
                return Class.forName(className, false, cl);
            }
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e1) {
            if (doFallback) {
                return Class.forName(className, false, FactoryFinder.class.getClassLoader());
            }
            throw e1;
        }
    }

    static <T> T newInstance(Class<T> type, String className, ClassLoader cl, boolean doFallback) throws TransformerFactoryConfigurationError {
        assert (type != null);
        boolean useBSClsLoader = false;
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            cl = null;
            useBSClsLoader = true;
        }
        try {
            Class<?> providerClass = FactoryFinder.getProviderClass(className, cl, doFallback, useBSClsLoader);
            if (!type.isAssignableFrom(providerClass)) {
                throw new ClassCastException(className + " cannot be cast to " + type.getName());
            }
            Object instance = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return type.cast(instance);
        }
        catch (ClassNotFoundException x) {
            throw new TransformerFactoryConfigurationError(x, "Provider " + className + " not found");
        }
        catch (Exception x) {
            throw new TransformerFactoryConfigurationError(x, "Provider " + className + " could not be instantiated: " + x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T find(Class<T> type, String fallbackClassName) throws TransformerFactoryConfigurationError {
        T provider;
        String factoryId;
        block16: {
            block15: {
                assert (type != null);
                factoryId = type.getName();
                FactoryFinder.dPrint("find factoryId =" + factoryId);
                try {
                    String systemProp = ss.getSystemProperty(factoryId);
                    if (systemProp != null) {
                        FactoryFinder.dPrint("found system property, value=" + systemProp);
                        return FactoryFinder.newInstance(type, systemProp, null, true);
                    }
                }
                catch (SecurityException se) {
                    if (!debug) break block15;
                    se.printStackTrace();
                }
            }
            try {
                String factoryClassName;
                if (firstTime) {
                    Properties se = cacheProps;
                    synchronized (se) {
                        if (firstTime) {
                            String configFile = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                FactoryFinder.dPrint("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                if ((factoryClassName = cacheProps.getProperty(factoryId)) != null) {
                    FactoryFinder.dPrint("found in $java.home/jaxp.properties, value=" + factoryClassName);
                    return FactoryFinder.newInstance(type, factoryClassName, null, true);
                }
            }
            catch (Exception ex) {
                if (!debug) break block16;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findServiceProvider(type)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new TransformerFactoryConfigurationError(null, "Provider for " + factoryId + " cannot be found");
        }
        FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(type, fallbackClassName, null, true);
    }

    private static <T> T findServiceProvider(final Class<T> type) throws TransformerFactoryConfigurationError {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    ServiceLoader serviceLoader = ServiceLoader.load(type);
                    Iterator iterator = serviceLoader.iterator();
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError e) {
            RuntimeException x = new RuntimeException("Provider for " + type + " cannot be created", e);
            TransformerFactoryConfigurationError error = new TransformerFactoryConfigurationError(x, x.getMessage());
            throw error;
        }
    }

    static {
        try {
            String val = ss.getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }
}

