/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.parser;

import com.oracle.cie.nextgen.common.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineParser {
    private Map<String, String> jvmProperties;
    private Set<String> jvmOptions;
    private Map<String, String> options;
    private Map<String, String> variables;
    private List<String> invalidArgs;

    public CommandLineParser(String[] args) {
        this(args, false);
    }

    public CommandLineParser(String[] args, boolean parseOnlyOptions) {
        this.parseCommandLineArgs(args, parseOnlyOptions);
    }

    private void parseCommandLineArgs(String[] args, boolean parseOnlyOptions) {
        this.init(parseOnlyOptions, Util.isEmpty(args));
        if (Util.isEmpty(args)) {
            return;
        }
        String currOption = null;
        for (String arg : args) {
            if (arg == null) continue;
            if (arg.startsWith("-J-")) {
                this.addOption(currOption);
                currOption = null;
                String jvmArg = arg.substring(2);
                if (jvmArg.startsWith("-D")) {
                    String[] vars = jvmArg.substring(2).split("=");
                    if (vars.length == 2) {
                        this.jvmProperties.put(vars[0], vars[1]);
                        continue;
                    }
                    if (vars.length == 1) {
                        this.jvmProperties.put(vars[0], "");
                        continue;
                    }
                    this.invalidArgs.add(arg);
                    continue;
                }
                if (!Util.isNullOrBlank(jvmArg, true)) {
                    this.jvmOptions.add(jvmArg);
                    continue;
                }
                this.invalidArgs.add(arg);
                continue;
            }
            if (arg.startsWith("-") && arg.contains("=")) {
                this.addOption(currOption);
                currOption = null;
                this.invalidArgs.add(arg);
                continue;
            }
            if (arg.contains(":") && arg.contains("=") && arg.indexOf(":") < arg.indexOf("=")) {
                this.addOption(currOption);
                currOption = null;
                this.invalidArgs.add(arg);
                continue;
            }
            if (arg.contains("=")) {
                this.addOption(currOption);
                currOption = null;
                if (parseOnlyOptions) continue;
                String[] vars = arg.split("=");
                if (vars.length == 2) {
                    this.variables.put(vars[0], vars[1]);
                    continue;
                }
                this.variables.put(vars[0], null);
                continue;
            }
            if (arg.startsWith("-") && !arg.contains(".")) {
                this.addOption(currOption);
                currOption = arg.substring(1, arg.length());
                continue;
            }
            if (currOption != null) {
                this.options.put(currOption, arg);
                currOption = null;
                continue;
            }
            this.invalidArgs.add(arg);
        }
        this.addOption(currOption);
    }

    private void init(boolean parseOnlyOptions, boolean isArgEmpty) {
        this.variables = new LinkedHashMap<String, String>(0);
        if (isArgEmpty) {
            this.options = new LinkedHashMap<String, String>(0);
            this.invalidArgs = new ArrayList<String>(0);
            this.jvmProperties = new LinkedHashMap<String, String>(0);
            this.jvmOptions = new LinkedHashSet<String>(0);
        } else {
            this.options = new LinkedHashMap<String, String>();
            this.invalidArgs = new ArrayList<String>();
            this.jvmProperties = new LinkedHashMap<String, String>();
            this.jvmOptions = new LinkedHashSet<String>();
            if (!parseOnlyOptions) {
                this.variables = new LinkedHashMap<String, String>();
            }
        }
    }

    private void addOption(String currOption) {
        if (currOption != null) {
            this.options.put(currOption, null);
        }
    }

    public Map<String, String> getOptions() {
        if (this.options == null) {
            return new HashMap<String, String>(0);
        }
        return Collections.unmodifiableMap(this.options);
    }

    public Map<String, String> getVariables() {
        if (this.variables == null) {
            return new HashMap<String, String>(0);
        }
        return Collections.unmodifiableMap(this.variables);
    }

    public Map<String, String> getJVMProperties() {
        if (this.jvmProperties == null) {
            return new HashMap<String, String>(0);
        }
        return Collections.unmodifiableMap(this.jvmProperties);
    }

    public Set<String> getJVMOptions() {
        if (this.jvmOptions == null) {
            return new HashSet<String>(0);
        }
        return Collections.unmodifiableSet(this.jvmOptions);
    }

    public List<String> getInvalidArgs() {
        if (this.invalidArgs == null) {
            return new ArrayList<String>(0);
        }
        return Collections.unmodifiableList(this.invalidArgs);
    }

    public boolean isInvalidArgsPassed() {
        return !Util.isEmpty(this.invalidArgs);
    }

    public boolean isOptionPassed(String key, boolean isCaseSensitive) {
        return CommandLineParser.isKeyPresent(this.getOptions().keySet(), key, isCaseSensitive);
    }

    public boolean isInputPresent(String key, boolean isCaseSensitive) {
        return CommandLineParser.isKeyPresent(this.getOptions().keySet(), key, isCaseSensitive) || CommandLineParser.isKeyPresent(this.getVariables().keySet(), key, isCaseSensitive);
    }

    private static boolean isKeyPresent(Set<String> keys, String key, boolean isCaseSensitive) {
        if (Util.isEmpty(keys)) {
            return false;
        }
        if (isCaseSensitive) {
            return keys.contains(key);
        }
        for (String item : keys) {
            if (!item.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }
}

