/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Input;
import com.oracle.cie.nextgen.common.inputs.enums.DataType;
import com.oracle.cie.nextgen.common.inputs.helpers.InputsUtil;
import com.oracle.cie.nextgen.common.utils.Util;
import java.util.HashSet;

public abstract class InputImpl
implements Input {
    private String name;
    private Object value;
    private boolean mandatory;
    private boolean isDirty;
    private String help;
    private String errMsg;
    private boolean deprecated;
    private DataType dataType;

    protected InputImpl(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value != null && value instanceof String && this.dataType != DataType.STRING ? InputsUtil.getValueObject((String)value, this.dataType) : value;
        this.isDirty = true;
    }

    public void setDefaultValue(String value) {
        this.value = InputsUtil.getValueObject(value, this.dataType);
    }

    public boolean isValueSet() {
        return this.isDirty;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public void setErrorMessage(String errMsg) {
        this.errMsg = errMsg;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public String getStringValue() {
        String retVal = null;
        if (this.value == null) {
            if (DataType.BOOLEAN.equals((Object)this.dataType)) {
                retVal = Boolean.FALSE.toString();
            }
        } else {
            retVal = DataType.STRING_ARRAY.equals((Object)this.dataType) ? Util.getInputString((String[])this.value) : this.value.toString();
        }
        return retVal;
    }

    public abstract boolean validate();

    protected boolean validateFile(String file) {
        if (!Util.isFileExists(file)) {
            this.setErrorMessage(NLS.getMsg("invalid.path", file));
            return false;
        }
        return true;
    }

    protected boolean validateFile(String[] files) {
        if (Util.isEmpty(files)) {
            return true;
        }
        HashSet<String> paths = new HashSet<String>(files.length);
        for (String file : files) {
            if (Util.isFileExists(file)) continue;
            paths.add(file);
        }
        if (!Util.isEmpty(paths)) {
            String msgKey = paths.size() == 1 ? "invalid.path" : "invalid.paths";
            String args = Util.getString(paths);
            this.setErrorMessage(NLS.getMsg(msgKey, args));
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Input && Util.equals(this.getName(), ((Input)obj).getName());
    }
}

