/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.helpers;

import com.oracle.cie.nextgen.common.inputs.enums.DataType;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.variables.VariableInputType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class InputsUtil {
    private static final String FULL_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Set<String> getInterSection(Set<String> set1, Set<String> set2) {
        if (Util.isEmpty(set1) || Util.isEmpty(set2)) {
            return new HashSet<String>(0);
        }
        HashSet<String> options = new HashSet<String>(set1);
        options.retainAll(set2);
        return options;
    }

    public static Set<String> getSubtraction(Set<String> set1, Set<String> set2) {
        if (Util.isEmpty(set1)) {
            return new HashSet<String>(0);
        }
        HashSet<String> options = new HashSet<String>(set1);
        if (!Util.isEmpty(set2)) {
            options.removeAll(set2);
        }
        return options;
    }

    public static Object getValueObject(String value, DataType type) {
        if (DataType.BOOLEAN.equals((Object)type)) {
            if (value == null) {
                return Boolean.FALSE;
            }
            return Boolean.parseBoolean(value);
        }
        if (DataType.DATE.equals((Object)type)) {
            return InputsUtil.getSimpleDate(value);
        }
        if (DataType.INTEGER.equals((Object)type)) {
            if (value == null) {
                return Integer.valueOf("0");
            }
            return Integer.parseInt(value);
        }
        if (DataType.STRING_ARRAY.equals((Object)type)) {
            return Util.getStringArray(value);
        }
        return value;
    }

    public static Object getSimpleDate(String value) {
        SimpleDateFormat df = new SimpleDateFormat(FULL_DATE_FORMAT, Locale.US);
        try {
            Date d = df.parse(value);
            return d;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getOptionKey(String option) {
        if (option == null || !option.contains(".")) {
            return option;
        }
        return option.substring(option.lastIndexOf(".") + 1, option.length());
    }

    public static String getOptionKey(String option, boolean isCaseSensitive) {
        String retVal = InputsUtil.getOptionKey(option);
        if (!isCaseSensitive) {
            return retVal.toLowerCase();
        }
        return retVal;
    }

    public static String getOptionPrefix(String option) {
        if (option != null && option.contains(".")) {
            return option.substring(0, option.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static boolean vaildate(String value) {
        if (Util.isNullOrBlank(value, true)) {
            return false;
        }
        value = value.trim();
        try {
            Integer.valueOf(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                return true;
            }
            if (value.startsWith("{") && !value.endsWith("}")) {
                return false;
            }
            if (value.startsWith("\"") && !value.endsWith("\"")) {
                return false;
            }
            return !value.startsWith("\"") || value.length() != 1;
        }
    }

    public static VariableInputType getInputType(Object value) {
        block8: {
            if (value != null) {
                if (value instanceof Integer) {
                    return VariableInputType.NUMBER;
                }
                if (value instanceof Boolean) {
                    return VariableInputType.BOOLEAN;
                }
                String stringValue = null;
                if (value instanceof String) {
                    stringValue = (String)value;
                }
                if (stringValue == null) {
                    return VariableInputType.STRING;
                }
                try {
                    Integer.valueOf(stringValue);
                    return VariableInputType.NUMBER;
                }
                catch (NumberFormatException nfe) {
                    if (Boolean.TRUE.toString().equalsIgnoreCase(stringValue) || Boolean.FALSE.toString().equalsIgnoreCase(stringValue)) {
                        return VariableInputType.BOOLEAN;
                    }
                    if (!stringValue.startsWith("{") || !stringValue.endsWith("}")) break block8;
                    return VariableInputType.STRING_LIST;
                }
            }
        }
        return VariableInputType.STRING;
    }

    public static boolean isComponentVariable(String variable) {
        return variable != null && variable.contains(":") && (!variable.contains("=") || variable.contains("=") && variable.indexOf(":") < variable.indexOf("="));
    }
}

