/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.iniMerger;

import com.oracle.cie.nextgen.common.iniMerger.GenericPrereqsSectionResolver;
import com.oracle.cie.nextgen.common.iniMerger.OracleSectionResolver;
import com.oracle.cie.nextgen.common.iniMerger.SectionResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class OraparamIniConflictResolver {
    private static final Logger _log = Logger.getLogger(OraparamIniConflictResolver.class.getName());
    private SectionResolver sectionResolver;
    private HashMap<String, Set<String>> unresolvedParams;

    public void resolve(HashMap<String, Set<String>> sectionMap, String iniSection) {
        if (iniSection.equals("Oracle")) {
            this.sectionResolver = new OracleSectionResolver();
            this.sectionResolver.resolve(sectionMap);
            this.unresolvedParams = this.sectionResolver.getUnresolvedParams();
            this.removeUnresolvedParams(sectionMap);
        } else if (iniSection.equals("Generic Prereqs")) {
            this.sectionResolver = new GenericPrereqsSectionResolver();
            this.sectionResolver.resolve(sectionMap);
            this.unresolvedParams = this.sectionResolver.getUnresolvedParams();
            this.removeUnresolvedParams(sectionMap);
        } else {
            _log.warning("Trying to resolve an unsupported section: " + iniSection);
        }
    }

    private void removeUnresolvedParams(HashMap<String, Set<String>> sectionMap) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : sectionMap.entrySet()) {
            if (!this.unresolvedParams.containsKey(entry.getKey())) continue;
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            sectionMap.remove(key);
        }
    }

    public HashMap<String, Set<String>> getUnresolvedParams() {
        return this.unresolvedParams;
    }
}

