/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.iniMerger;

import com.oracle.cie.nextgen.common.iniMerger.SectionResolver;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class GenericPrereqsSectionResolver
implements SectionResolver {
    private static final Logger _log = Logger.getLogger(GenericPrereqsSectionResolver.class.getName());
    private HashMap<String, Set<String>> unresolvedParams;

    @Override
    public void resolve(HashMap<String, Set<String>> sectionMap) {
        if (this.unresolvedParams == null) {
            this.unresolvedParams = new HashMap();
        }
        for (Map.Entry<String, Set<String>> entry : sectionMap.entrySet()) {
            String key = entry.getKey();
            LinkedHashSet values = (LinkedHashSet)entry.getValue();
            if (key.equals("TEMP_SPACE") || key.equals("SWAP_SPACE") || key.equals("MIN_DISPLAY_COLORS") || key.equals("CPU")) {
                StringBuilder numeric = new StringBuilder();
                long max = 0L;
                for (String value : values) {
                    long current = 0L;
                    try {
                        current = Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        _log.warning("Ignoring invalid numeric value of " + key + ": " + value);
                    }
                    if (current <= max) continue;
                    max = current;
                }
                values.clear();
                numeric.append(max);
                values.add(numeric.toString());
                continue;
            }
            if (key.equals("GMAKE") || key.equals("PACKAGES") || key.equals("PATCHES") || key.equals("JAVA_USE_64BIT")) {
                StringBuilder csv = new StringBuilder();
                LinkedHashSet<String> singles = new LinkedHashSet<String>();
                for (String value : values) {
                    for (String single : value.split(",")) {
                        singles.add(single);
                    }
                }
                for (String single : singles) {
                    csv.append(single + ",");
                }
                values.clear();
                values.add(csv.substring(0, csv.length() - 1));
                continue;
            }
            if (key.equals("GLIBC")) {
                String topVersion = "0.0";
                for (String value : values) {
                    if (!VersionHelper.isValidVersion(value) || VersionHelper.compare(topVersion, value) != -1) continue;
                    topVersion = value;
                }
                values.clear();
                values.add(topVersion);
                continue;
            }
            if (key.equals("PROCESSOR") || key.equals("BUNDLE") || key.equals("CERTIFIED_VERSION_LOCATION") || key.equals("CERTIFIED_VERSION_WARN") || key.equals("FILESET") || key.equals("KERNEL") || key.equals("PERL") || key.equals("SERVICE_PACK")) continue;
            _log.info("The next key and value are not supported. Key=" + key + " Value=" + values);
            this.unresolvedParams.put(key, values);
        }
    }

    @Override
    public void setUnresolvedParams(HashMap<String, Set<String>> params) {
        this.unresolvedParams = params;
    }

    @Override
    public HashMap<String, Set<String>> getUnresolvedParams() {
        return this.unresolvedParams;
    }
}

