/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FileLocatorService {
    private static final Logger _log = Logger.getLogger(FileLocatorService.class.getName());
    private static Map<String, FileLocatorService> _serviceCache = new HashMap<String, FileLocatorService>();
    private String _id;
    private List<Path> _locations;

    public static FileLocatorService getFileLocatorService(String id) {
        FileLocatorService service = _serviceCache.get(id);
        if (service == null) {
            service = new FileLocatorService(id);
            _serviceCache.put(id, service);
        }
        return service;
    }

    private FileLocatorService(String id) {
        this._id = id;
        this._locations = new ArrayList<Path>();
    }

    public String getId() {
        return this._id;
    }

    public void setLocations(List<File> locations) {
        this._locations = new ArrayList<Path>();
        if (locations != null) {
            for (File location : locations) {
                this._locations.add(NioHelper.getInstance().getPath(location));
            }
        }
    }

    public void setLocationPaths(List<Path> locations) {
        this._locations.clear();
        if (locations != null) {
            this._locations.addAll(locations);
        }
    }

    public List<File> getLocations() {
        ArrayList<File> locations = new ArrayList<File>();
        for (Path location : this.getLocationPaths()) {
            locations.add(location.toFile());
        }
        return locations;
    }

    public List<Path> getLocationPaths() {
        return this._locations;
    }

    public boolean isEmpty() {
        return this._locations.isEmpty();
    }

    public void addLocation(File location) {
        this._locations.add(NioHelper.getInstance().getPath(location));
    }

    public void addLocation(Path location) {
        this._locations.add(location);
    }

    public void addLocations(File parentLocation, String[] subDirs) {
        if (parentLocation != null) {
            for (String subDir : subDirs) {
                this.addLocation(new File(parentLocation, subDir));
            }
        }
    }

    public void addLocations(Path parentLocation, String[] subDirs) {
        if (parentLocation != null) {
            for (String subDir : subDirs) {
                this.addLocation(parentLocation.resolve(subDir));
            }
        }
    }

    public File getFile(String name) throws FileNotFoundException {
        return this.getFile(null, name);
    }

    public File getFile(String path, String name) throws FileNotFoundException {
        return this.getPath(path, name).toFile();
    }

    public List<File> getFiles(String path, String name) throws FileNotFoundException {
        List<Path> paths = this.getPaths(path, name);
        ArrayList<File> located = new ArrayList<File>();
        for (Path p : paths) {
            located.add(p.toFile());
        }
        return located;
    }

    public List<File> getFilesUnderPath(String path) {
        List<Path> paths = this.getPathsUnderPath(path);
        ArrayList<File> located = new ArrayList<File>();
        for (Path p : paths) {
            located.add(p.toFile());
        }
        return located;
    }

    public Path getPath(String name) throws FileNotFoundException {
        return this.getPath(null, name);
    }

    public Path getPath(String path, String name) throws FileNotFoundException {
        String fullpath = path == null || path.trim().length() < 1 ? name : path + File.separator + name;
        Path locatedPath = null;
        for (Path location : this._locations) {
            Path p = location.resolve(fullpath);
            if (!Files.exists(p, new LinkOption[0])) continue;
            locatedPath = p;
            break;
        }
        if (locatedPath == null) {
            FileNotFoundException ex = new FileNotFoundException("Unable to locate file " + fullpath + " under lookup locations " + this._locations);
            _log.finer(ex.getMessage());
            throw ex;
        }
        return locatedPath;
    }

    public List<Path> getPaths(String path, String name) throws FileNotFoundException {
        ArrayList<Path> located = new ArrayList<Path>();
        String fullpath = path == null || path.trim().length() < 1 ? name : path + File.separator + name;
        for (Path location : this._locations) {
            Path p = location.resolve(fullpath);
            if (!Files.exists(p, new LinkOption[0]) || located.contains(p)) continue;
            located.add(p);
        }
        if (located.isEmpty()) {
            FileNotFoundException ex = new FileNotFoundException("Unable to locate file " + fullpath + " under lookup locations " + this._locations);
            _log.finer(ex.getMessage());
            throw ex;
        }
        return located;
    }

    public List<Path> getPathsUnderPath(String path) {
        HashMap<String, Path> fileMap = new HashMap<String, Path>();
        if (path != null) {
            for (Path location : this._locations) {
                Path dir = location.resolve(path);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                    for (Path p : stream) {
                        String name;
                        if (!Files.isRegularFile(p, new LinkOption[0]) || fileMap.containsKey(name = p.getFileName().toString())) continue;
                        fileMap.put(name, p);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new ArrayList<Path>(fileMap.values());
    }

    public static String getAbsolutePath(File startingFile, String pathValue) {
        if (!new File(pathValue).isAbsolute() && startingFile != null) {
            File f = startingFile.getAbsoluteFile();
            if (!startingFile.isDirectory()) {
                f = f.getParentFile();
            }
            if (f != null) {
                String[] split;
                for (String s : split = pathValue.replace("\\", "/").split("/")) {
                    if ("..".equals(s)) {
                        f = f.getParentFile();
                        continue;
                    }
                    if (".".equals(s)) continue;
                    f = new File(f, s);
                }
                return f.getAbsolutePath();
            }
        }
        return pathValue;
    }
}

