/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class EncodingService {
    public static int MAXIMUM_VALUE_LENGTH = 5;

    public static String encode(Set<Integer> values) {
        String encoding = "";
        if (values != null && !values.isEmpty()) {
            TreeSet<Integer> sorted = new TreeSet<Integer>(values);
            String s = "1";
            for (Integer i : sorted) {
                String is = i.toString();
                while (is.length() < MAXIMUM_VALUE_LENGTH) {
                    is = "0" + is;
                }
                s = s + is;
            }
            encoding = new BigInteger(s).toString(36);
        }
        return encoding;
    }

    public static Set<Integer> decode(String encoded) {
        LinkedHashSet<Integer> decoded = new LinkedHashSet<Integer>();
        if (!StringUtil.isNullOrEmpty((String)encoded, (boolean)true)) {
            String s = new BigInteger(encoded, 36).toString();
            s = s.substring(1);
            ArrayList<String> values = new ArrayList<String>();
            int len = s.length();
            for (int i = 0; i < len; i += MAXIMUM_VALUE_LENGTH) {
                values.add(s.substring(i, Math.min(len, i + MAXIMUM_VALUE_LENGTH)));
            }
            for (String value : values) {
                while (value.startsWith("0")) {
                    value = value.substring(1);
                }
                decoded.add(Integer.parseInt(value));
            }
        }
        return decoded;
    }
}

