/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.gdr.nio.FileSystemType;
import com.oracle.cie.gdr.nio.NioServiceProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class CompatibleNioServiceProxy
implements NioServiceProxy {
    CompatibleNioServiceProxy() {
    }

    @Override
    public void resetDefaultFileSystemHandler() {
    }

    @Override
    public void setFileSystemType(FileSystemType fileSystemType) {
        if (fileSystemType != null) {
            throw new IllegalStateException("The file system type " + (Object)((Object)fileSystemType) + " is not supported by this NIO service proxy implementation.");
        }
    }

    @Override
    public void newFileSystem(Path fileSystemPath) throws IOException {
    }

    @Override
    public void newFileSystem(Path fileSystemPath, Map<String, Object> env) throws IOException {
    }

    @Override
    public FileSystemType getFileSystemType() {
        return null;
    }

    @Override
    public URI getURI(String pathString) throws URISyntaxException {
        if (pathString == null) {
            throw new NullPointerException("The path string provided was null.");
        }
        return new URI("file", null, pathString.replace("\\", "/"), null);
    }

    @Override
    public Path getPath(File file) {
        return file != null ? file.toPath() : null;
    }

    @Override
    public Path getPath(String first, String ... more) {
        return Paths.get(first, more);
    }

    @Override
    public Path getPath(URI uri) {
        return Paths.get(uri);
    }

    @Override
    public FileSystem getFileSystem(Path path) {
        return path.getFileSystem();
    }

    @Override
    public Path getInternalPath(Path path) {
        return path;
    }

    @Override
    public URL getURL(Path path) throws MalformedURLException {
        return path.toUri().toURL();
    }

    @Override
    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        return Files.copy(in, target, options);
    }

    @Override
    public CopyOption getChecksumCopyOption(String checksum) {
        return null;
    }
}

