/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pli;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.pli.Alias;
import com.oracle.cie.gdr.dao.pli.PlatformProperties;
import java.util.ArrayList;
import java.util.List;

public class Platform
extends AbstractDataHandlerWrapper {
    public Platform(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public int getId() {
        return (Integer)this.getNumberAttribute("id", Integer.class);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public String getDirectoryName() {
        return this.getStringAttribute("directory-name");
    }

    public String getLegacyName() {
        return this.getStringAttribute("legacy-name");
    }

    public int getARUId() {
        return (Integer)this.getNumberAttribute("aru-id", Integer.class);
    }

    public String getARUDescription() {
        return this.getStringAttribute("aru-description");
    }

    public PlatformProperties getBaseProperties() {
        return (PlatformProperties)((Object)this.getSingleOccuranceComplexValueWrapped("base-properties", PlatformProperties.class));
    }

    public List<PlatformProperties> getExtraProperties() {
        return this.getComplexValueWrappedList("extra-properties", PlatformProperties.class);
    }

    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        IDataHandler[] dhs = this.getDataHandler().getComplexValue("group");
        if (dhs != null && dhs.length > 0) {
            for (IDataHandler dh : dhs) {
                String name = (String)dh.getAttributeValue("name");
                if (name == null) continue;
                groups.add(name);
            }
        }
        return groups;
    }

    public List<Alias> getAliases() {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        IDataHandler[] dhs = this.getDataHandler().getComplexValue("alias");
        if (dhs != null && dhs.length > 0) {
            for (IDataHandler dh : dhs) {
                aliases.add(new Alias(dh));
            }
        }
        return aliases;
    }
}

