/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.TreeData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class XMLTreeData
implements TreeData {
    private Properties _attributes = null;
    private String _text = "";
    private List<String> _comments = new ArrayList<String>();

    public String getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.getProperty(name);
    }

    public void setAttribute(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Attributes name and value must be non-null!");
        }
        if (this._attributes == null) {
            this._attributes = new Properties();
        }
        this._attributes.setProperty(name, value);
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.remove(name);
        }
    }

    public Properties getAttributes() {
        if (this._attributes == null) {
            this._attributes = new Properties();
        }
        return this._attributes;
    }

    public void setAttributes(Properties attributes) {
        this._attributes = attributes;
    }

    public void addAttributes(Properties attributes) {
        if (this._attributes == null) {
            this._attributes = new Properties();
        }
        this._attributes.putAll((Map<?, ?>)attributes);
    }

    public void clearAttributes() {
        this._attributes = null;
    }

    public int getAttributeCount() {
        return this._attributes == null ? 0 : this._attributes.size();
    }

    public boolean hasAttributes() {
        return this._attributes != null && !this._attributes.isEmpty();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void appendText(String text) {
        this._text = this._text + text;
    }

    public boolean hasText() {
        return this._text != null && !"".equals(this._text);
    }

    public void addComment(String comment) {
        this._comments.add(comment);
    }

    public void insertComment(String comment, int index) {
        if (index > -1 && index < this._comments.size()) {
            this._comments.add(index, comment);
        }
    }

    public void removeComment(int index) {
        if (index > -1 && index < this._comments.size()) {
            this._comments.remove(index);
        }
    }

    public List<String> getComments() {
        return this._comments;
    }

    public boolean hasComments() {
        return !this._comments.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XMLTreeData ");
        if (this.hasAttributes()) {
            Enumeration<?> attrEnum = this._attributes.propertyNames();
            while (attrEnum.hasMoreElements()) {
                String attrName = (String)attrEnum.nextElement();
                sb.append(attrName).append("='");
                sb.append(this._attributes.getProperty(attrName));
                sb.append("' ");
            }
        }
        sb.append("text='").append(this._text).append("' ");
        return sb.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XMLTreeData data = new XMLTreeData();
        data.getAttributes().putAll((Map<?, ?>)this.getAttributes());
        data.setText(this.getText());
        return data;
    }
}

