/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeFilterAdapter;
import java.util.HashSet;

public class TreeIdFilter
extends TreeFilterAdapter {
    public static final int EXCLUDE = -1;
    public static final int INCLUDE = 1;
    private int _mode = -1;
    private HashSet<String> _filterSet = new HashSet();

    public TreeIdFilter() {
    }

    public TreeIdFilter(int mode) {
        this(mode, null);
    }

    public TreeIdFilter(int mode, String id) {
        int n = this._mode = mode > 0 ? 1 : -1;
        if (id != null) {
            this._filterSet.add(id);
        }
    }

    public TreeIdFilter(HashSet<String> ids) {
        if (ids == null) {
            this._filterSet.clear();
        } else {
            this._filterSet = ids;
        }
    }

    public void setMode(int mode) {
        this._mode = mode > 0 ? 1 : -1;
    }

    public void clear() {
        this._filterSet.clear();
    }

    public void addId(String id) {
        this._filterSet.add(id);
    }

    @Override
    public boolean isAccepted(Tree t) {
        return this._mode == -1 ? !this._filterSet.contains(t.getId()) : this._filterSet.contains(t.getId());
    }
}

