/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.DepthFirstTreeIterator;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeData;
import com.oracle.cie.common.tree.TreeFilter;
import com.oracle.cie.common.tree.TreeFilterAdapter;
import com.oracle.cie.common.tree.TreeHelper;
import com.oracle.cie.common.tree.TreePath;
import com.oracle.cie.common.tree.TreeVisitor;
import java.util.ArrayList;
import java.util.List;

public class BasicTree
implements Tree {
    private String _id = "";
    private TreeData _treeData = null;
    private List<Tree> _children = null;
    private Tree _parent = null;

    public BasicTree(String id) {
        if (this._id == null) {
            throw new IllegalArgumentException("Id must not be null!");
        }
        this._id = id;
    }

    public BasicTree(String id, Tree parent) {
        this(id);
        this._parent = parent;
    }

    public BasicTree(String id, TreeData data) {
        this(id);
        this._treeData = data;
    }

    public BasicTree(String id, Tree parent, TreeData data) {
        this(id, parent);
        this._treeData = data;
    }

    @Override
    public Tree getChild(int index) {
        return this._children == null ? null : (index < 0 || index >= this._children.size() ? null : this._children.get(index));
    }

    @Override
    public void addChild(Tree t) {
        if (this._children == null) {
            this._children = new ArrayList<Tree>();
        }
        t.setParent(this);
        this._children.add(t);
    }

    @Override
    public void removeChild(Tree t) {
        int index = this.getIndexOfChild(t);
        if (index == -1) {
            throw new IllegalArgumentException("The tree is not a child.");
        }
        t.setParent(null);
        this._children.remove(index);
    }

    @Override
    public void insertChild(int index, Tree t) {
        if (index >= this.getChildCount()) {
            throw new IllegalArgumentException("Index out of range.");
        }
        if (this._children == null) {
            this._children = new ArrayList<Tree>();
        }
        t.setParent(this);
        this._children.add(index, t);
    }

    @Override
    public int getIndexOfChild(Tree t) {
        return this._children == null ? -1 : this._children.indexOf(t);
    }

    @Override
    public List<Tree> getChildTreesWithId(String id) {
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Tree child = this.getChild(i);
            if (!child.getId().equals(id)) continue;
            treeList.add(child);
        }
        return treeList;
    }

    @Override
    public Tree getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Tree t) {
        this._parent = t;
    }

    @Override
    public TreePath getPathToSubTree(Tree subTree) {
        Tree parent;
        TreePath path = new TreePath(subTree.getId());
        for (parent = subTree.getParent(); parent != null && this != parent; parent = parent.getParent()) {
            path.prepend(parent.getId());
        }
        return parent == null ? null : path;
    }

    @Override
    public List<Tree> getSubTreesWithId(final String id) {
        final ArrayList<Tree> treeList = new ArrayList<Tree>();
        TreeVisitor nameVisitor = new TreeVisitor(){

            @Override
            public void visitTree(Tree t, TreeFilter filter) {
                if (t.getId().equals(id)) {
                    treeList.add(t);
                }
            }
        };
        TreeHelper.depthFirstTraversal((Tree)this, nameVisitor);
        return treeList;
    }

    @Override
    public List<Tree> getSubTreesWithPath(final TreePath path) {
        final ArrayList<Tree> treeList = new ArrayList<Tree>();
        TreeVisitor pathVisitor = new TreeVisitor(){

            @Override
            public void visitTree(Tree t, TreeFilter filter) {
                if (filter.isAccepted(t)) {
                    treeList.add(t);
                }
            }
        };
        TreeFilterAdapter filter = new TreeFilterAdapter(){

            @Override
            public boolean isAccepted(Tree t) {
                return path.equals(t.getPath());
            }
        };
        DepthFirstTreeIterator it = this.depthIterator();
        while (it.hasNext()) {
            pathVisitor.visitTree((Tree)it.next(), filter);
        }
        return treeList;
    }

    @Override
    public boolean isLeaf() {
        return this._children == null || this._children.isEmpty();
    }

    @Override
    public boolean isRoot() {
        return this._parent == null;
    }

    @Override
    public int getChildCount() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public int getHeight() {
        int r = 0;
        int t = 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (r >= (t += this.getChild(i).getHeight())) continue;
            r = t;
        }
        return r;
    }

    @Override
    public int getDepth() {
        int r = 0;
        for (Tree t = this.getParent(); t != null; t = t.getParent()) {
            ++r;
        }
        return r;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id can't be null!");
        }
        this._id = id;
    }

    @Override
    public DepthFirstTreeIterator depthIterator() {
        return new DepthFirstTreeIterator(this);
    }

    @Override
    public DepthFirstTreeIterator depthIterator(TreeFilter filter) {
        return new DepthFirstTreeIterator(this, filter);
    }

    @Override
    public TreeData getData() {
        return this._treeData;
    }

    @Override
    public void setData(TreeData data) {
        this._treeData = data;
    }

    @Override
    public TreePath getPath() {
        TreePath path = new TreePath(this.getId());
        for (Tree parent = this.getParent(); parent != null; parent = parent.getParent()) {
            path.prepend(parent.getId());
        }
        return path;
    }

    public String toString() {
        return this._treeData == null ? "" : this._treeData.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BasicTree tree = new BasicTree(this.getId());
        TreeData data = (TreeData)this.getData().clone();
        tree.setData(data);
        for (int i = 0; i < this.getChildCount(); ++i) {
            tree.addChild((Tree)this.getChild(i).clone());
        }
        return tree;
    }
}

