/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.jaxb.JaxbDataHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class JaxbDataHandlerSpiImpl
extends DataHandlerSpi {
    private static final Logger _log = Logger.getLogger(JaxbDataHandlerSpiImpl.class.getName());
    private static Map<ClassLoader, Map<String, Collection<JaxbPackageInfo>>> _packageInfo = new CacheHashMap<ClassLoader, Map<String, Collection<JaxbPackageInfo>>>(5);
    private static Map<String, Map<ClassLoader, Unmarshaller>> _unmarshallerCache = new HashMap<String, Map<ClassLoader, Unmarshaller>>();

    @Override
    public IDataHandler create(String namespace, String id, ClassLoader classloader) {
        JaxbPackageInfo info = this.locateTypePackageInfo(namespace, id, classloader);
        if (info != null) {
            try {
                Object o;
                Class<?> objfac = info.getObjectFactoryClass();
                Method m = this.getObjectFactoryCreateMethod(objfac, id);
                if (m != null && (o = m.invoke(info.getObjectFactory(), new Object[0])) != null) {
                    return new JaxbDataHandler(o, id);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IDataHandler create(String namespace, String id, File file, ClassLoader classloader) throws DataHandlerException {
        try {
            Object o = SecureUnmarshaller.unmarshal((Unmarshaller)this.getUnmarshaller(namespace, id, classloader), (File)file);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return new JaxbDataHandler(o, id);
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, InputStream is, ClassLoader classloader) throws DataHandlerException {
        try {
            Object o = SecureUnmarshaller.unmarshal((Unmarshaller)this.getUnmarshaller(namespace, id, classloader), (InputStream)is);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return new JaxbDataHandler(o, id);
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, String s, ClassLoader classloader) throws DataHandlerException {
        try {
            Object o = SecureUnmarshaller.unmarshal((Unmarshaller)this.getUnmarshaller(namespace, id, classloader), (Reader)new StringReader(s));
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return new JaxbDataHandler(o, id);
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, URL url, ClassLoader classloader) throws DataHandlerException {
        try {
            Object o = this.getUnmarshaller(namespace, id, classloader).unmarshal(url);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return new JaxbDataHandler(o, id);
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, SAXSource source, ClassLoader classloader) throws DataHandlerException {
        try {
            Object o = this.getUnmarshaller(namespace, id, classloader).unmarshal((Source)source);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return new JaxbDataHandler(o, id);
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler createFromJson(String namespace, String id, File file, ClassLoader classloader) throws DataHandlerException {
        try {
            Class<?> jaxbClass = JaxbDataHandlerSpiImpl.getClassFromObjectFactory(namespace, id, null, classloader);
            if (jaxbClass == null) {
                throw new DataHandlerException("Unable to locate jaxb class for " + id + " in namespace " + namespace);
            }
            Object o = JaxbDataHandlerSpiImpl.class.getClassLoader().loadClass("com.oracle.cie.common.dao.jaxb.JaxbJsonHandler").getMethod("readJson", Class.class, File.class).invoke(null, jaxbClass, file);
            return new JaxbDataHandler(o, id);
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler createFromJson(String namespace, String id, InputStream is, ClassLoader classloader) throws DataHandlerException {
        try {
            Class<?> jaxbClass = JaxbDataHandlerSpiImpl.getClassFromObjectFactory(namespace, id, null, classloader);
            if (jaxbClass == null) {
                throw new DataHandlerException("Unable to locate jaxb class for " + id + " in namespace " + namespace);
            }
            Object o = JaxbDataHandlerSpiImpl.class.getClassLoader().loadClass("com.oracle.cie.common.dao.jaxb.JaxbJsonHandler").getMethod("readJson", Class.class, InputStream.class).invoke(null, jaxbClass, is);
            return new JaxbDataHandler(o, id);
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
    }

    private Unmarshaller getUnmarshaller(String namespace, String id, ClassLoader classloader) throws DataHandlerException {
        Unmarshaller unmarshaller;
        if (classloader == null) {
            classloader = JaxbDataHandlerSpiImpl.class.getClassLoader();
        }
        Unmarshaller unmarshaller2 = unmarshaller = _unmarshallerCache.get(namespace + ":" + id) != null ? _unmarshallerCache.get(namespace + ":" + id).get(classloader) : null;
        if (unmarshaller != null) {
            return unmarshaller;
        }
        JaxbPackageInfo info = this.locateTypePackageInfo(namespace, id, classloader);
        if (info == null) {
            throw new DataHandlerException("Unable to locate type " + id + " in namespace " + namespace);
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{info.getObjectFactoryClass()});
            unmarshaller = context.createUnmarshaller();
            Schema schema = JaxbDataHandlerSpiImpl.getSchema(namespace, id, classloader);
            if (schema != null) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Located schema for namespace=" + namespace + " id=" + id + ", enabling unmarshalling validation.");
                }
                unmarshaller.setSchema(schema);
            } else if (_log.isLoggable(Level.FINE)) {
                _log.fine("Unable to located schema for namespace=" + namespace + " id=" + id + ", disabling unmarshalling validation.");
            }
            HashMap<ClassLoader, Unmarshaller> cache = new HashMap<ClassLoader, Unmarshaller>();
            cache.put(classloader, unmarshaller);
            _unmarshallerCache.put(namespace + ":" + id, cache);
            Unmarshaller unmarshaller3 = unmarshaller;
            return unmarshaller3;
        }
        catch (JAXBException e) {
            throw new DataHandlerException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static Schema getSchema(String namespace, String element, ClassLoader classloader) {
        Collection<JaxbPackageInfo> infos = JaxbDataHandlerSpiImpl.getPackageInfo(namespace, classloader);
        if (infos != null && !infos.isEmpty()) {
            for (JaxbPackageInfo info : infos) {
                Method[] methods;
                Class<?> objectFactoryClass = info.getObjectFactoryClass();
                for (Method method : methods = objectFactoryClass.getMethods()) {
                    XmlElementDecl xmldecl = method.getAnnotation(XmlElementDecl.class);
                    if (xmldecl == null) continue;
                    String ns = xmldecl.namespace();
                    String name = xmldecl.name();
                    if (ns == null || !ns.equals(namespace) || name == null || !name.equals(element)) continue;
                    return info.getSchema();
                }
            }
        }
        return null;
    }

    public static Collection<JaxbPackageInfo> getPackageInfo(String namespace, ClassLoader classloader) {
        Map<String, Collection<JaxbPackageInfo>> packageInfo;
        if (classloader == null) {
            classloader = JaxbDataHandlerSpiImpl.class.getClassLoader();
        }
        if ((packageInfo = _packageInfo.get(classloader)) == null || !packageInfo.containsKey(namespace)) {
            packageInfo = JaxbDataHandlerSpiImpl.getPackageInfo(classloader);
            _packageInfo.put(classloader, packageInfo);
        }
        return packageInfo != null ? packageInfo.get(namespace) : null;
    }

    private static Map<String, Collection<JaxbPackageInfo>> getPackageInfo(ClassLoader classloader) {
        Map<Class, String> objectFactoryMap = JaxbDataHandlerSpiImpl.locateObjectFactories(classloader);
        Map<String, Schema> schemaMap = JaxbDataHandlerSpiImpl.getSchemaMap(objectFactoryMap, classloader);
        HashMap<String, Collection<JaxbPackageInfo>> packageInfo = new HashMap<String, Collection<JaxbPackageInfo>>();
        for (Class objectFactory : objectFactoryMap.keySet()) {
            XmlSchema a;
            Package pack = objectFactory.getPackage();
            if (pack == null || (a = pack.getAnnotation(XmlSchema.class)) == null) continue;
            String namespace = a.namespace();
            JaxbPackageInfo info = new JaxbPackageInfo(namespace, objectFactory, schemaMap.get(namespace));
            ArrayList<JaxbPackageInfo> col = (ArrayList<JaxbPackageInfo>)packageInfo.get(namespace);
            if (col == null) {
                col = new ArrayList<JaxbPackageInfo>();
                packageInfo.put(namespace, col);
            }
            col.add(info);
        }
        return packageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, String> locateObjectFactories(ClassLoader classloader) {
        LinkedHashMap<Class, String> objectFactoryMap = new LinkedHashMap<Class, String>();
        Enumeration<URL> packagedefs = null;
        try {
            packagedefs = classloader.getResources("META-INF/com/oracle/cie/common/dao/jaxb/jaxb-packages.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (packagedefs != null) {
            while (packagedefs.hasMoreElements()) {
                URL packagedef = packagedefs.nextElement();
                Properties jaxbProperties = new Properties();
                InputStream is = null;
                try {
                    is = packagedef.openStream();
                    jaxbProperties.load(is);
                    Set<String> packageNames = jaxbProperties.stringPropertyNames();
                    for (String packageName : packageNames) {
                        try {
                            String schemaName;
                            Class<?> objectFactory = classloader.loadClass(packageName + ".ObjectFactory");
                            if (objectFactory == null || (schemaName = jaxbProperties.getProperty(packageName, "")) == null || schemaName.length() <= 0) continue;
                            objectFactoryMap.put(objectFactory, packageName.replaceAll("\\.", "/") + "/" + schemaName);
                        }
                        catch (Exception e) {
                            _log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                catch (IOException e) {
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.log(Level.FINE, "Error loading data from jaxb-packages properties file: " + packagedef, e);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return objectFactoryMap;
    }

    private static Map<String, Schema> getSchemaMap(final Map<Class, String> objectFactoryMap, final ClassLoader classloader) {
        HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                try {
                    InputStream schemaIn;
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                    LSInput ret = domImplementationLS.createLSInput();
                    String schemaLocation = null;
                    for (Class objectFactory : objectFactoryMap.keySet()) {
                        String namespace = JaxbDataHandlerSpiImpl.getNamespace(objectFactory);
                        if (namespace == null || !namespace.equals(namespaceURI)) continue;
                        String schemaLoc = (String)objectFactoryMap.get(objectFactory);
                        if (systemId != null && systemId.length() > 0) {
                            if (!schemaLoc.endsWith(systemId)) continue;
                            schemaLocation = schemaLoc;
                            break;
                        }
                        schemaLocation = schemaLoc;
                        break;
                    }
                    if (schemaLocation != null && (schemaIn = classloader.getResourceAsStream(schemaLocation)) != null) {
                        ret.setByteStream(schemaIn);
                        ret.setSystemId(systemId);
                        return ret;
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, e.getMessage(), e);
                }
                return null;
            }
        });
        for (Class objectFactory : objectFactoryMap.keySet()) {
            String namespace;
            String schemaLocation = objectFactoryMap.get(objectFactory);
            if (schemaLocation == null || schemaLocation.length() <= 0 || (namespace = JaxbDataHandlerSpiImpl.getNamespace(objectFactory)) == null) continue;
            Schema schema = JaxbDataHandlerSpiImpl.loadSchema(schemaLocation, schemaFactory, classloader);
            schemaMap.put(namespace, schema);
        }
        return schemaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema loadSchema(String schemaLocation, SchemaFactory schemaFactory, ClassLoader classloader) {
        InputStream schemaIn;
        if (schemaLocation != null && schemaLocation.length() > 0 && (schemaIn = classloader.getResourceAsStream(schemaLocation)) != null) {
            try {
                Schema schema = schemaFactory.newSchema(new StreamSource(schemaIn));
                return schema;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    schemaIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static String getNamespace(Class objectFactoryClass) {
        XmlSchema a;
        Package pack = objectFactoryClass.getPackage();
        if (pack != null && (a = pack.getAnnotation(XmlSchema.class)) != null) {
            return a.namespace();
        }
        return null;
    }

    private JaxbPackageInfo locateTypePackageInfo(String namespace, String id, ClassLoader classloader) {
        Collection<JaxbPackageInfo> packageInfo = JaxbDataHandlerSpiImpl.getPackageInfo(namespace, classloader);
        if (packageInfo != null) {
            for (JaxbPackageInfo info : packageInfo) {
                Class<?> objfac = info.getObjectFactoryClass();
                if (this.getObjectFactoryCreateMethod(objfac, id) == null) continue;
                return info;
            }
        }
        _log.warning("Unable to locate type " + id + " in namespace " + namespace);
        return null;
    }

    static Class<?> getClassFromObjectFactory(String namespace, String element, Class<?> scope, ClassLoader classloader) {
        Collection<JaxbPackageInfo> packageInfo = JaxbDataHandlerSpiImpl.getPackageInfo(namespace, classloader);
        if (packageInfo != null) {
            for (JaxbPackageInfo info : packageInfo) {
                Method[] methods;
                Class<?> objfac = info.getObjectFactoryClass();
                for (Method method : methods = objfac.getMethods()) {
                    Class<?>[] params;
                    XmlElementDecl xmldecl = method.getAnnotation(XmlElementDecl.class);
                    if (xmldecl == null) continue;
                    String ns = xmldecl.namespace();
                    String name = xmldecl.name();
                    Class scp = xmldecl.scope();
                    if (ns == null || !ns.equals(namespace) || name == null || !name.equals(element) || scope != null && (scp == null || !scp.equals(scope)) || (params = method.getParameterTypes()) == null || params.length != 1) continue;
                    return params[0];
                }
            }
        }
        return null;
    }

    private Method getObjectFactoryCreateMethod(Class<?> objfac, String id) {
        Method m = null;
        try {
            m = objfac.getMethod("create" + JaxbDataHandlerSpiImpl.getPropertyFromElement(id) + "Type", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                m = objfac.getMethod("create" + JaxbDataHandlerSpiImpl.getPropertyFromElement(id), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return m;
    }

    public static String getPropertyFromElement(String element) {
        int index;
        String result = element.substring(0, 1).toUpperCase(Locale.ENGLISH) + element.substring(1);
        while ((index = result.indexOf("-")) != -1) {
            if (index >= result.length()) continue;
            result = result.substring(0, index) + result.substring(index + 1, index + 2).toUpperCase(Locale.ENGLISH) + result.substring(index + 2);
        }
        while ((index = result.indexOf("_")) != -1) {
            if (index >= result.length()) continue;
            result = result.substring(0, index) + result.substring(index + 1, index + 2).toUpperCase(Locale.ENGLISH) + result.substring(index + 2);
        }
        return result;
    }

    static class JaxbPackageInfo {
        String _namespace;
        Class<?> _objectFactoryClass;
        Schema _schema;
        Object _objectFactory;

        JaxbPackageInfo(String namespace, Class<?> objectFactoryClass, Schema schema) {
            this._namespace = namespace;
            this._objectFactoryClass = objectFactoryClass;
            this._schema = schema;
        }

        public String getNamespace() {
            return this._namespace;
        }

        public Class<?> getObjectFactoryClass() {
            return this._objectFactoryClass;
        }

        public Schema getSchema() {
            return this._schema;
        }

        public Object getObjectFactory() {
            if (this._objectFactory == null) {
                try {
                    Constructor<?> c = this._objectFactoryClass.getConstructor(new Class[0]);
                    return c.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this._objectFactory;
        }

        public Package getPackage() {
            return this._objectFactoryClass.getPackage();
        }
    }

    private static class CacheHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private int _maxEntries;

        public CacheHashMap(int maxEntries) {
            super(maxEntries, 0.75f, true);
            this._maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._maxEntries;
        }
    }
}

