/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class AbstractDataHandlerWrapper
implements IDataHandlerWrapper {
    private static final Logger _log = Logger.getLogger(AbstractDataHandlerWrapper.class.getName());
    private IDataHandler _dataHandler;

    protected AbstractDataHandlerWrapper(IDataHandler dataHandler) {
        assert (dataHandler != null);
        this._dataHandler = dataHandler;
    }

    @Override
    public IDataHandler getDataHandler() {
        return this._dataHandler;
    }

    public ClassLoader getObjectClassLoader() {
        return this.getDataHandler().getObject().getClass().getClassLoader();
    }

    protected String getStringAttribute(String name) {
        Object value = this.getDataHandler().getAttributeValue(name);
        if (value != null && !(value instanceof String)) {
            return value.toString();
        }
        return (String)value;
    }

    protected void setAttribute(String name, Object value) {
        this.getDataHandler().setAttributeValue(name, value);
    }

    protected void setSimpleValue(String name, Object value) {
        this.setSimpleValue(this.getDataHandler(), name, value);
    }

    protected void setSimpleValue(IDataHandler dataHandler, String name, Object value) {
        dataHandler.setSimpleValue(name, value);
    }

    protected boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, false);
    }

    protected boolean getBooleanAttribute(String name, boolean defaultValue) {
        Object value = this.getDataHandler().getAttributeValue(name);
        if (value != null && !(value instanceof Boolean)) {
            return Boolean.valueOf(value.toString());
        }
        return value == null ? defaultValue : (Boolean)value;
    }

    protected Object getSimpleValue(String name) {
        return this.getDataHandler().getSimpleValue(name);
    }

    protected String getStringSimpleValue(String name) {
        Object value = this.getSimpleValue(name);
        return value != null ? value.toString() : null;
    }

    protected String[] getStringSimpleValueArray(String name) {
        return this.getStringSimpleValueArray(this.getDataHandler(), name);
    }

    protected String[] getStringSimpleValueArray(IDataHandler dataHandler, String name) {
        String[] stringArray;
        Object value = dataHandler.getSimpleValue(name);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] valueArray = (Object[])value;
                stringArray = new String[valueArray.length];
                for (int x = 0; x < valueArray.length; ++x) {
                    stringArray[x] = valueArray[x].toString();
                }
            } else {
                stringArray = new String[]{value.toString()};
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    protected <T extends Number> T getNumberAttribute(String name, Class<T> type) {
        Number def = null;
        try {
            Constructor<T> c = type.getConstructor(String.class);
            def = (Number)c.newInstance("-1");
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "An error ocurred while parsing the value of " + name, exception);
        }
        return (T)this.getNumberAttribute(name, type, def);
    }

    protected <T extends Number> T getNumberAttribute(String name, Class<T> type, T def) {
        Object value = this.getDataHandler().getAttributeValue(name);
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return (T)((Number)type.cast(value));
            }
            if (value instanceof String) {
                try {
                    Constructor<T> c = type.getConstructor(String.class);
                    return (T)((Number)c.newInstance((String)value));
                }
                catch (Exception exception) {
                    _log.log(Level.SEVERE, "An error ocurred while parsing the value of " + name, exception);
                }
            } else if (Number.class.isAssignableFrom(value.getClass())) {
                if (type.equals(Integer.class)) {
                    return (T)((Number)type.cast(((Number)value).intValue()));
                }
                if (type.equals(Long.class)) {
                    return (T)((Number)type.cast(((Number)value).longValue()));
                }
                if (type.equals(Float.class)) {
                    return (T)((Number)type.cast(Float.valueOf(((Number)value).floatValue())));
                }
                if (type.equals(Double.class)) {
                    return (T)((Number)type.cast(((Number)value).doubleValue()));
                }
                if (type.equals(Short.class)) {
                    return (T)((Number)type.cast(((Number)value).shortValue()));
                }
                if (type.equals(Byte.class)) {
                    return (T)((Number)type.cast(((Number)value).byteValue()));
                }
            }
        }
        return def;
    }

    protected Calendar getCalendarAttribute(String name) {
        Calendar calendar = null;
        Object value = this.getDataHandler().getAttributeValue(name);
        if (value != null) {
            if (value instanceof XMLGregorianCalendar) {
                calendar = ((XMLGregorianCalendar)value).toGregorianCalendar();
            } else if (value instanceof Calendar) {
                calendar = (Calendar)value;
            } else {
                try {
                    Date date = DateFormat.getInstance().parse(value.toString());
                    calendar = Calendar.getInstance();
                    calendar.setTime(date);
                }
                catch (ParseException parseException) {
                    _log.log(Level.SEVERE, "An error ocurred while parsing the value of " + name, parseException);
                }
            }
        }
        return calendar;
    }

    protected IDataHandler getSingleOccuranceComplexValue(String name) {
        return this.getSingleOccuranceComplexValue(this.getDataHandler(), name);
    }

    protected IDataHandler getSingleOccuranceComplexValue(String name, boolean create) {
        return this.getSingleOccuranceComplexValue(this.getDataHandler(), name, create);
    }

    protected IDataHandler getSingleOccuranceComplexValue(IDataHandler dataHandler, String name) {
        return this.getSingleOccuranceComplexValue(dataHandler, name, false);
    }

    protected IDataHandler getSingleOccuranceComplexValue(IDataHandler dataHandler, String name, boolean create) {
        if (dataHandler != null) {
            IDataHandler[] value = dataHandler.getComplexValue(name);
            if (value != null && value.length > 0) {
                return value[0];
            }
            if (create) {
                return dataHandler.addComplexValue(name);
            }
        }
        return null;
    }

    protected <T> T getSingleOccuranceComplexValueWrapped(String name, Class<T> wrapperClass) {
        return this.getSingleOccuranceComplexValueWrapped(name, wrapperClass, false);
    }

    protected <T> T getSingleOccuranceComplexValueWrapped(String name, Class<T> wrapperClass, boolean create) {
        return this.getSingleOccuranceComplexValueWrapped(this.getDataHandler(), name, wrapperClass, create);
    }

    protected <T> T getSingleOccuranceComplexValueWrapped(IDataHandler dataHandler, String name, Class<T> wrapperClass) {
        return this.getSingleOccuranceComplexValueWrapped(dataHandler, name, wrapperClass, false);
    }

    protected <T> T getSingleOccuranceComplexValueWrapped(IDataHandler dataHandler, String name, Class<T> wrapperClass, boolean create) {
        IDataHandler value = this.getSingleOccuranceComplexValue(dataHandler, name, create);
        if (value != null) {
            try {
                Constructor<T> constructor = wrapperClass.getConstructor(IDataHandler.class);
                return constructor.newInstance(value);
            }
            catch (Exception exception) {
                _log.log(Level.SEVERE, "An error ocurred while parsing the value of " + name, exception);
            }
        }
        return null;
    }

    protected <T extends IDataHandlerWrapper> void setSingleOccuranceComplexValueWrapped(String name, T wrapper) {
        this.setSingleOccuranceComplexValueWrapped(this.getDataHandler(), name, wrapper);
    }

    protected <T extends IDataHandlerWrapper> void setSingleOccuranceComplexValueWrapped(IDataHandler dataHandler, String name, T wrapper) {
        dataHandler.setComplexValue(name, wrapper != null ? wrapper.getDataHandler() : null);
    }

    protected <T extends IDataHandlerWrapper> List<T> getComplexValueWrappedList(String name, Class<T> wrapperClass) {
        return DataHandlerHelper.getWrapperList(this.getDataHandler(), name, wrapperClass);
    }

    protected <T extends IDataHandlerWrapper> void setComplexValueWrappedList(String name, List<T> wrappers) {
        DataHandlerHelper.setWrapperList(this.getDataHandler(), name, wrappers);
    }

    protected <T extends IDataHandlerWrapper> List<T> getSingleOccurrenceChildComplexValueWrappedList(String parentName, String name, Class<T> wrapperClass) {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue(parentName), name, wrapperClass);
    }

    protected <T extends IDataHandlerWrapper> void setSingleOccurrenceChildComplexValueWrappedList(String parentName, String name, List<T> wrappers) {
        DataHandlerHelper.setWrapperList(this.getSingleOccuranceComplexValue(parentName, true), name, wrappers);
    }

    protected String[] getSingleOccurrenceChildStringSimpleValueArray(String parentName, String name) {
        IDataHandler parentDataHandler = this.getSingleOccuranceComplexValue(parentName);
        return parentDataHandler != null ? this.getStringSimpleValueArray(parentDataHandler, name) : new String[]{};
    }

    protected void setSingleOccurrenceChildSimpleValue(String parentName, String name, Object value) {
        this.setSimpleValue(this.getSingleOccuranceComplexValue(parentName, true), name, value);
    }

    public String toString() {
        return this._dataHandler == null ? "" : this._dataHandler.toString();
    }
}

