/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDaoFactory {
    private static final Logger _log = Logger.getLogger(AbstractDaoFactory.class.getName());
    private static HashMap<ClassLoader, DataHandlerSpi> _providerCache = new HashMap();

    protected static DataHandlerSpi getProvider(ClassLoader classloader) {
        return AbstractDaoFactory.getProvider(classloader, null);
    }

    public static DataHandlerSpi getProvider(ClassLoader classloader, String providerClassName) {
        return AbstractDaoFactory.getProvider(classloader, providerClassName, false);
    }

    public static synchronized DataHandlerSpi getProvider(ClassLoader classloader, String providerClassName, boolean reload) {
        ClassLoader cl;
        DataHandlerSpi provider = null;
        ClassLoader classLoader = cl = classloader == null ? AbstractDaoFactory.class.getClassLoader() : classloader;
        if (!reload) {
            provider = _providerCache.get(cl);
        }
        if (provider == null && (provider = providerClassName != null && providerClassName.length() > 0 ? DataHandlerSpi.getDataHandlerProvider(cl, providerClassName) : DataHandlerSpi.getDataHandlerProvider(cl)) != null) {
            _providerCache.put(cl, provider);
        }
        return provider;
    }

    protected Object createWrapperObject(String id, String namespace, Class<?> cls) {
        return this.createWrapperObject(id, namespace, cls, null);
    }

    protected Object createWrapperObject(String id, String namespace, Class<?> cls, ClassLoader classloader) {
        try {
            Constructor<?> constructor = cls.getConstructor(IDataHandler.class);
            return constructor.newInstance(AbstractDaoFactory.getProvider(classloader).create(namespace, id, classloader));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Unable to create DAO object.", e);
            return null;
        }
    }
}

