/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.HAS;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.rules.CRSversionGreater;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.causes.WrongVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class SIHAVersionCheckIfSupported
extends BaseRule {
    Logger logger = Logger.getLogger(SIHAVersionCheckIfSupported.class.getName());
    String minHASversion = "11.2.0.4";
    private String minUnSupportedCrsVersion = "12.2";

    public SIHAVersionCheckIfSupported(SystemInstance config) {
        super(config);
        this.successMessage = "SIHA patching is supported for this version";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that SIHA version is greater than " + this.minHASversion);
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no has object exists.");
            List hasList = this.config.getTargetsOfType(HAS.class);
            if (hasList == null || hasList.isEmpty()) {
                this.logger.log(Level.FINE, "HAS does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(SIHAVersionCheckIfSupported.class, (String)"NO_HAS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (hasList.size() != 1) {
                this.logger.log(Level.FINE, "More than one HAS object recognized. Set top to the HAS Object");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(SIHAVersionCheckIfSupported.class, (String)"MULTIPLE_HAS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the HAS Object");
            this.config.setTop((AbstractBaseTarget)hasList.get(0));
        } else if (!(this.config.getTop() instanceof HAS)) {
            this.logger.log(Level.FINE, "SystemInstance top is not HAS object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(SIHAVersionCheckIfSupported.class, (String)"TOP_NOT_HAS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        HAS has = (HAS)this.config.getTop();
        ArrayList<HAS> list = new ArrayList<HAS>();
        ArrayList<WrongVersion> failureCauses = new ArrayList<WrongVersion>();
        String verHAS = has.getVersion();
        if (verHAS == null || verHAS.length() == 0) {
            this.logger.log(Level.FINE, "HAS object is missing the version information.");
            list.add(has);
            nullCauses.add(new MissingVersion(list, BundleUtils.getMessage(SIHAVersionCheckIfSupported.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        if (has.getVersion().trim().compareToIgnoreCase(this.minHASversion) >= 0) {
            if (this.config.getTop().getProperty(SkipTargetCookie.class) == null && has.getVersion().trim().compareToIgnoreCase(this.minUnSupportedCrsVersion) >= 0) {
                this.logger.log(Level.FINE, "HAS version is not supported from oplan. For HAS Version 12.2 onwards please use OPatch auto.");
                failureCauses.add(new WrongVersion(list, BundleUtils.getMessage(CRSversionGreater.class, (String)"HAS_VERSION_HIGHER", (Object[])new Object[]{this.minUnSupportedCrsVersion, BundleUtils.makeStringOutOfList(list)})));
                return new RuleResult((Rule)this, new Boolean(false), failureCauses);
            }
            this.logger.log(Level.FINE, "SIHA version is greater than the minimum required version");
            return new RuleResult((Rule)this);
        }
        list.add(has);
        this.logger.log(Level.FINE, "Current SIHA version is less than the minimum version required.");
        failureCauses.add(new WrongVersion(list, BundleUtils.getMessage(SIHAVersionCheckIfSupported.class, (String)"HAS_VERSION_NOT_SUPPORTED", (Object[])new Object[]{this.minHASversion, BundleUtils.makeStringOutOfList(list)})));
        return new RuleResult((Rule)this, new Boolean(false), failureCauses);
    }
}

