/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.PhaseType;
import oracle.oplan.db.sdk.SIPatchingContext;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.causes.NoRACinstances;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.causes.WrongVersion;
import oracle.osysmodel.validation.rules.BaseRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RACOneVersionRule
extends BaseRule {
    Logger logger = Logger.getLogger(RACOneVersionRule.class.getName());
    private String strMinRACversion = null;

    public RACOneVersionRule(SystemInstance config, String strMinRACversion) {
        super(config);
        this.strMinRACversion = strMinRACversion;
        this.successMessage = " RAC version is greater or equal to " + strMinRACversion;
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that RACOne version is greater than " + this.strMinRACversion);
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACOneVersionRule.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(RACOneVersionRule.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACOneVersionRule.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The CRS does not have any RAC Databases running out of it.");
            list.add(crs);
            nullCauses.add((Object)new NoRAC(list, BundleUtils.getMessage(RACOneVersionRule.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDatabase> noInstances = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.FINE, "There are RAC Databases with no instances associated");
            noInstances.add(rac);
        }
        if (!noInstances.isEmpty()) {
            nullCauses.add((Object)new NoRACinstances(noInstances, BundleUtils.getMessage(RACOneVersionRule.class, (String)"NO_RACINSTANCE", (Object[])new Object[]{BundleUtils.makeStringOutOfList(noInstances)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> instMissingVersion = new ArrayList<RACDBInstance>();
        ArrayList<RACDatabase> wrongVersion = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            if (!"racone".equals(rac.getDatabaseType())) continue;
            String verRAC = null;
            for (RACDBInstance instance : rac.getDbInstances()) {
                String verInst = instance.getVersion();
                if (verInst == null) {
                    instMissingVersion.add(instance);
                    continue;
                }
                if (verRAC != null) continue;
                verRAC = verInst;
            }
            if (verRAC == null || verRAC.trim().compareToIgnoreCase(this.strMinRACversion) >= 0) continue;
            if (this.checkIfPatchingOnlyRACone(rac, racs)) {
                this.logger.log(Level.FINE, "Given RACOnes have a version that is not supported for RACOne only patching");
                wrongVersion.add(rac);
                continue;
            }
            this.dontPatchIncompatibleRACOneDB(rac);
        }
        if (!instMissingVersion.isEmpty()) {
            nullCauses.add(new MissingVersion(instMissingVersion, BundleUtils.getMessage(RACOneVersionRule.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(instMissingVersion)})));
            return new RuleResult((Rule)this, (Boolean)null, nullCauses);
        }
        if (!wrongVersion.isEmpty()) {
            ArrayList<WrongVersion> failureCauses = new ArrayList<WrongVersion>();
            failureCauses.add(new WrongVersion(wrongVersion, BundleUtils.getMessage(RACOneVersionRule.class, (String)"RAC_VERSION_NOT_SUPPORTED", (Object[])new Object[]{BundleUtils.makeStringOutOfList(wrongVersion)})));
            return new RuleResult((Rule)this, Boolean.FALSE, failureCauses);
        }
        this.logger.log(Level.FINE, "All RACs have a version greater than the minimum required version");
        return new RuleResult((Rule)this);
    }

    private void dontPatchIncompatibleRACOneDB(RACDatabase racDB) {
        SIPatchingContext context = new SIPatchingContext(this.config, OPlan.getInstance().getConfigGraph(this.config), false);
        context.dontTouchRacDatabase(racDB, new PhaseType[0]);
    }

    private boolean checkIfPatchingOnlyRACone(RACDatabase racOne, List<RACDatabase> allDBs) {
        boolean checkIfPatchingOnlyRACone = true;
        List crss = this.config.getTargetsOfType(CRSCluster.class);
        assert (crss.size() == 1);
        if (crss.size() != 1) {
            throw new IllegalStateException("Found none or more than one CRSCluster objects in the systemInstance: " + crss);
        }
        CRSCluster crs = (CRSCluster)crss.get(0);
        this.logger.fine("Checking CRSCluster: " + crs);
        if (crs.getProperty(SkipTargetCookie.class) != null) {
            for (HAS has : this.l(crs.getHAS())) {
                this.logger.fine("Not going to touch HAS: " + has);
                if (has.getProperty(SkipTargetCookie.class) != null) continue;
                checkIfPatchingOnlyRACone = false;
                break;
            }
            for (RACDatabase rac : allDBs) {
                if (rac == racOne || rac.getProperty(SkipTargetCookie.class) != null) continue;
                checkIfPatchingOnlyRACone = false;
                break;
            }
        } else {
            checkIfPatchingOnlyRACone = false;
        }
        return checkIfPatchingOnlyRACone;
    }

    private <T> List<T> l(List<T> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }
}

