/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.oplan.db.validation.causes.InvalidHomeType;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.rules.BaseRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleHomeTypeValid
extends BaseRule {
    Logger logger = Logger.getLogger(OracleHomeTypeValid.class.getName());

    public OracleHomeTypeValid(SystemInstance config) {
        super(config);
        this.successMessage = " All Oracle home Type is valid ";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure all home type of Oracle Home is recognized by OPlan.");
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        List<String> validHomeType = this.getValidHomeType();
        List homeList = this.config.getTargetsOfType(OracleHome.class);
        if (homeList == null || homeList.isEmpty()) {
            this.logger.log(Level.FINE, "Oracle Home does not exist.");
            failureCauses.add(new MissingHome(null, BundleUtils.getMessage(OracleHomeTypeValid.class, (String)"NO_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[0])));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        for (AbstractBaseTarget abt : homeList) {
            OracleHome home = (OracleHome)abt;
            if (validHomeType.contains(home.getHomeType())) continue;
            failureCauses.add((Object)new InvalidHomeType(null, BundleUtils.getMessage(OracleHomeTypeValid.class, (String)"INVALID_HOMETYPE", (Object[])new Object[]{home.getHomeType(), home.getDisplayName()})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }

    private List<String> getValidHomeType() {
        ArrayList<String> validHomeType = new ArrayList<String>();
        validHomeType.add("crs");
        validHomeType.add("siha");
        validHomeType.add("sidb");
        validHomeType.add("rac");
        return validHomeType;
    }
}

