/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.rules.BaseRule;

public class GIHomeValid
extends BaseRule {
    Logger logger = Logger.getLogger(GIHomeValid.class.getName());

    public GIHomeValid(SystemInstance config) {
        super(config);
        this.successMessage = " GIhome configuration is valid";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to check if the GIHomes exist and include the host details.");
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        ArrayList<OracleHome> list = new ArrayList<OracleHome>();
        List homes = this.config.getTargetsOfType(OracleHome.class);
        if (homes == null || homes.isEmpty()) {
            this.logger.log(Level.FINE, "The system instance contains no homes.");
            failureCauses.add(new MissingHome(null, BundleUtils.getMessage(GIHomeValid.class, (String)"NO_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[0])));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        ArrayList<OracleHome> giHomes = new ArrayList<OracleHome>();
        for (AbstractBaseTarget abt : homes) {
            OracleHome home = (OracleHome)abt;
            if (!home.getHomeType().equals("crs")) continue;
            this.logger.log(Level.FINEST, "Found GIHome at" + home.getPath());
            giHomes.add(home);
        }
        if (giHomes == null || giHomes.isEmpty()) {
            this.logger.log(Level.FINE, "The configuration contains no Grid Infrastructure homes. ");
            failureCauses.add(new MissingHome(null, BundleUtils.getMessage(GIHomeValid.class, (String)"NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[]{"Grid Infrastructure"})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        for (OracleHome gihome : giHomes) {
            List hosts = gihome.getHosts();
            if (hosts != null && !hosts.isEmpty()) continue;
            this.logger.log(Level.FINE, "GIHome at path " + gihome.getPath() + " doesn't have the host information set.");
            list.add(gihome);
        }
        if (list != null && !list.isEmpty()) {
            failureCauses.add(new MissingHost(list, BundleUtils.getMessage(GIHomeValid.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

