/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import model.SystemInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.DataGuardPresent;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSLogicalStandbyNotUsed
extends BaseRule {
    public CRSLogicalStandbyNotUsed(SystemInstance config) {
        super(config);
        this.successMessage = "Ensures Logical Standby Database is not used.";
    }

    public RuleResult invoke() {
        this.logger.log(Level.FINE, "Invoking rule to ensure that the logical standby database is not used.");
        ArrayList<NoRAC> nullCauses = new ArrayList<NoRAC>();
        List racDatabases = this.config.getTargetsOfType(RACDatabase.class);
        if (racDatabases == null || racDatabases.isEmpty()) {
            this.logger.log(Level.FINE, "The system instance contains rac database.");
            nullCauses.add(new NoRAC(null, BundleUtils.getMessage(CRSLogicalStandbyNotUsed.class, (String)"NO_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDatabase> logicalStandbyDBs = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racDatabases) {
            if (rac.getDataguardStatus() == null || !rac.getDataguardStatus().equalsIgnoreCase("logical standby")) continue;
            this.logger.log(Level.FINEST, "Found logical standby rac database " + rac.getDatabaseName());
            logicalStandbyDBs.add(rac);
        }
        ArrayList<DataGuardPresent> failureCauses = new ArrayList<DataGuardPresent>();
        if (!logicalStandbyDBs.isEmpty()) {
            failureCauses.add(new DataGuardPresent(logicalStandbyDBs, BundleUtils.getMessage(CRSLogicalStandbyNotUsed.class, (String)"LOGICAL_STANDBY", (Object[])new Object[]{BundleUtils.makeStringOutOfList(logicalStandbyDBs)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

