/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.intg;

import java.util.Comparator;
import model.SystemInstance;
import model.common.Host;
import oracle.oplan.db.automationselection.CRSAutomationSetSelection;
import oracle.oplan.db.cmdtranslator.DBCommandFactory;
import oracle.oplan.db.cookies.CRSMakeCloneHome;
import oracle.oplan.db.driver.crs.CRSDummyProductDriver;
import oracle.oplan.db.driver.crs.CRSHostComparator;
import oracle.oplan.db.driver.crs.CrsProductDriver;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.engine.CRSSequencingEngineUtils;
import oracle.oplan.db.graphlib.CRSConfigGraph;
import oracle.oplan.db.oplan.CRSConfigCompareHelper;
import oracle.oplan.db.oplan.CRSPreProcessor;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.db.ui.CRSSystemInstance2UI;
import oracle.oplan.db.validation.IsCRSConfigSupported;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.automationselection.AutomationSetSelection;
import oracle.oplan.sdk.cmdtranslator.CommandFactory;
import oracle.oplan.sdk.cookies.MakeCloneHome;
import oracle.oplan.sdk.engine.ContextPopulator;
import oracle.oplan.sdk.engine.SequencingEngineUtils;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.PreProcessor;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareHelper;
import oracle.oplan.sdk.patch.ApplicabilityTarget;
import oracle.oplan.sdk.ui.SystemInstance2UI;
import oracle.oplan.sdk.validation.IsConfigSupported;
import oracle.osysmodel.driver.sdk.productdriver.DummyProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.validation.ConfigValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBOPlanIntgFactory
extends OPlanIntgFactory {
    protected ProductDriver getProductDriverInstance() {
        return new CrsProductDriver();
    }

    protected DummyProductDriver getDummyProductDriverInstance() {
        return new CRSDummyProductDriver();
    }

    public CommandFactory getCommandFactory() {
        return new DBCommandFactory();
    }

    public ConfigGraph getConfigGraph(SystemInstance systemGraph, Host localHost) {
        if (this.configGraph == null) {
            this.configGraph = new CRSConfigGraph(systemGraph, localHost);
        }
        return this.configGraph;
    }

    public ContextPopulator getContextPopulator() {
        if (this.contextPopulator == null) {
            this.contextPopulator = new CRSContextPopulator();
        }
        return this.contextPopulator;
    }

    public ApplicabilityTarget getApplicabilityTarget() {
        if (this.applicabilityTarget == null) {
            this.applicabilityTarget = new CRSApplicabilityTarget();
        }
        return this.applicabilityTarget;
    }

    public PreProcessor getPreProcessor() {
        if (this.preProcessor == null) {
            this.preProcessor = new CRSPreProcessor();
        }
        return this.preProcessor;
    }

    public AutomationSetSelection getAutomationSetSelection() {
        if (this.automationSetSelection == null) {
            this.automationSetSelection = new CRSAutomationSetSelection();
        }
        return this.automationSetSelection;
    }

    public String getLogoLocation() {
        this.logoLocation = "oracle/oplan/db/logo/oracle_em_12c_logo.png";
        return this.logoLocation;
    }

    public String getLogoDesc() {
        this.logoDesc = "CRS Patching";
        return this.logoDesc;
    }

    public String getReadmeResourceBundleLocation() {
        this.readmeResourceBundleLocation = "oracle/oplan/db/readme/Bundle.properties";
        return this.readmeResourceBundleLocation;
    }

    public String getAutomationResourceBundleLocation() {
        this.autoResourceBundleLocation = "oracle/oplan/db/resource/AutomationBundle.properties";
        return this.autoResourceBundleLocation;
    }

    public IsConfigSupported getIsConfigSupported(SystemInstance config, ExecutionMode exeMode) throws ConfigValidationException {
        if (this.isConfigSupported == null) {
            this.isConfigSupported = new IsCRSConfigSupported(config, exeMode);
        }
        return this.isConfigSupported;
    }

    public SequencingEngineUtils getSequencingEngineUtils() {
        if (this.sequencingEngineUtils == null) {
            this.sequencingEngineUtils = new CRSSequencingEngineUtils();
        }
        return this.sequencingEngineUtils;
    }

    @Deprecated
    public MakeCloneHome getMakeCloneHome(ProductDriver pd, ConfigGraph cg) {
        if (this.makeCloneHome == null) {
            this.makeCloneHome = new CRSMakeCloneHome(pd, cg);
        }
        return this.makeCloneHome;
    }

    public MakeCloneHome getMakeCloneHome(ConfigGraph cg, LocalInfo localInfo) {
        if (this.makeCloneHome == null) {
            this.makeCloneHome = new CRSMakeCloneHome(cg, localInfo);
        }
        return this.makeCloneHome;
    }

    public SystemInstance2UI getSystemInstance2UI() {
        if (this.systemInstance2UI == null) {
            this.systemInstance2UI = new CRSSystemInstance2UI();
        }
        return this.systemInstance2UI;
    }

    public ConfigCompareHelper getConfigCompareHelper() {
        if (this.configCompareHelper == null) {
            this.configCompareHelper = new CRSConfigCompareHelper();
        }
        return this.configCompareHelper;
    }

    public Comparator<Host> getHostComparator() {
        if (this.hostComparator == null) {
            this.hostComparator = new CRSHostComparator();
        }
        return this.hostComparator;
    }
}

