/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.graphlib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.BaseSWComponent;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import model.db_crs.RACDBInstance;
import oracle.oplan.db.driver.crs.CRSDummyProductDriver;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlanInternalException;

public class CRSConfigGraph
extends ConfigGraph {
    public static Logger logger = Logger.getLogger(CRSConfigGraph.class.getName());

    public CRSConfigGraph(ConfigGraph.VertexComp c, SystemInstance si) {
        super(c, si);
    }

    public CRSConfigGraph(SystemInstance si, Host localHost) {
        super(si, localHost);
    }

    public Host initLocalHost(SystemInstance si, Host localHost) {
        if (localHost == null) {
            logger.info("localHost is null");
            List hostList = si.getTargetsOfType(Host.class);
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String localHostName = null;
                boolean found = false;
                if (addr != null) {
                    localHostName = addr.getHostName();
                    if (localHostName.indexOf(".") != -1) {
                        localHostName = localHostName.substring(0, localHostName.indexOf("."));
                    }
                    logger.info("localHostName get from InetAddress.getLocalHost is" + localHostName);
                    if (localHostName != null) {
                        for (Host host : hostList) {
                            if (!host.getHostName().equalsIgnoreCase(localHostName) && !host.getNodeName().equalsIgnoreCase(localHostName)) continue;
                            localHost = host;
                            found = true;
                            break;
                        }
                    }
                }
                if (addr == null || !found || localHostName == null) {
                    Collections.sort(hostList, new CRSDummyProductDriver.HostComparator());
                    localHost = (Host)hostList.get(0);
                    logger.info("Set localHost to first host in config graph " + localHost.getHostName());
                }
            }
            catch (UnknownHostException e) {
                throw new OPlanInternalException(e.getMessage(), (Throwable)e);
            }
        }
        return localHost;
    }

    public ConfigGraph.VertexComp getVertexCompInstance(Host localHost) {
        return new CRSVertexComp(localHost);
    }

    public DefaultMutableTreeNode createCRSTreeTable(CRSCluster cluster) {
        DefaultMutableTreeNode clusterNode = new DefaultMutableTreeNode(cluster);
        logger.log(Level.FINEST, "Cluster -> Host" + this.getConnectedTargets((AbstractBaseTarget)cluster, Host.class));
        for (Host host : this.getConnectedTargets((AbstractBaseTarget)cluster, Host.class)) {
            clusterNode.add(this.createTreeTableForHost(host));
        }
        return clusterNode;
    }

    public DefaultMutableTreeNode createHASTreeTable(HAS has) {
        DefaultMutableTreeNode hasNode = new DefaultMutableTreeNode(has);
        logger.log(Level.FINEST, "HAS -> Host" + this.getConnectedTargets((AbstractBaseTarget)has, Host.class));
        for (Host host : this.getConnectedTargets((AbstractBaseTarget)has, Host.class)) {
            hasNode.add(this.createTreeTableForHost(host));
        }
        return hasNode;
    }

    private DefaultMutableTreeNode createTreeTableForHost(Host host) {
        DefaultMutableTreeNode hostNode = new DefaultMutableTreeNode(host);
        logger.log(Level.FINEST, "Host -> OracleOH" + this.getConnectedTargets((AbstractBaseTarget)host, OracleHome.class));
        for (OracleHome home : this.getConnectedTargets((AbstractBaseTarget)host, OracleHome.class)) {
            DefaultMutableTreeNode homeNode = new DefaultMutableTreeNode(home);
            hostNode.add(homeNode);
            logger.log(Level.FINEST, "OracleOH -> Components" + this.getConnectedTargets((AbstractBaseTarget)home, BaseSWComponent.class));
            for (BaseSWComponent component : this.getConnectedTargets((AbstractBaseTarget)home, BaseSWComponent.class)) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(component);
                homeNode.add(node);
            }
        }
        return hostNode;
    }

    public DefaultMutableTreeNode createTreeTable() {
        AbstractBaseTarget root = this.getRootVertex();
        if (root instanceof CRSCluster) {
            CRSCluster cluster = (CRSCluster)root;
            return this.createCRSTreeTable(cluster);
        }
        if (root instanceof HAS) {
            HAS has = (HAS)root;
            return this.createHASTreeTable(has);
        }
        throw new OPlanInternalException("the top object of systemInstance is not Cluster or HAS.");
    }

    public class CRSVertexComp
    extends ConfigGraph.VertexComp {
        public CRSVertexComp(Host localHost) {
            super(localHost);
        }

        public Host getLocalHost() {
            return this.localHost;
        }

        public int compareHosts(Host h1, Host h2) {
            if (h1 == h2) {
                return 0;
            }
            if (h1 == this.localHost) {
                return -1;
            }
            if (h2 == this.localHost) {
                return 1;
            }
            return this.compareNames((AbstractBaseTarget)h1, (AbstractBaseTarget)h2);
        }

        public int compare(AbstractBaseTarget t1, AbstractBaseTarget t2) {
            Host h2;
            Host h1;
            int cmp = 0;
            if (t1 == t2) {
                return 0;
            }
            cmp = this.compareTypes(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof Host) {
                return this.compareHosts((Host)t1, (Host)t2);
            }
            cmp = this.compareNames(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof OracleHome && (cmp = this.compareHosts(h1 = (Host)((OracleHome)t1).getHosts().get(0), h2 = (Host)((OracleHome)t2).getHosts().get(0))) != 0) {
                return cmp;
            }
            if (t1 instanceof RACDBInstance && (cmp = this.compareHosts(h1 = ((RACDBInstance)t1).getHost(), h2 = ((RACDBInstance)t2).getHost())) != 0) {
                return cmp;
            }
            return t1.getUniqueId().compareTo(t2.getUniqueId());
        }
    }
}

