/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.cmdtranslator.commands.StopStartLogShipping;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopStartRedoApply
extends Command {
    static Logger logger = Logger.getLogger(StopStartLogShipping.class.getName());
    private final CRSCommandActionType type;
    private final Strategy strat;

    public StopStartRedoApply(ActionType automationAction, CRSCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (CRSCommandActionType.StartRedoApply.equals((Object)type) || CRSCommandActionType.StopRedoApply.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private List<ExecutionStep.Command> getRedoApplyCommand(ExecutionStep es, CommandContext cc) {
        ArrayList<ExecutionStep.Command> executionCmds = new ArrayList<ExecutionStep.Command>();
        String dbName = null;
        OracleHome oracleHome = null;
        AbstractBaseTarget standby = cc.getPrimaryTarget();
        if (standby instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)standby;
            dbName = rac.getDatabaseName();
            oracleHome = (OracleHome)cc.getFirstTarget(OracleHome.class);
        } else if (standby instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)standby;
            dbName = sidb.getDatabaseName();
            oracleHome = (OracleHome)cc.getFirstTarget(OracleHome.class);
        }
        String OracleSid = DBCommandUtils.getOracleSID(es, standby);
        logger.info("Data guard broker have not been configed");
        String sqlplusCmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/sqlplus / as sysdba";
        if (CRSCommandActionType.StartRedoApply.equals((Object)this.type)) {
            String sqlCommand = "ALTER DATABASE RECOVER MANAGED STANDBY DATABASE DISCONNECT FROM SESSION;";
            if (ExecutionMode.STANDALONE.equals((Object)OPlan.getInstance().getOPlanEnv().getExecutionMode())) {
                executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
                executionCmds.add(new ExecutionStep.Command(sqlCommand, ExecutionStep.Command.CommandType.SQL));
            } else {
                String tmpSqlFile = this.getTmpSqlFile(cc);
                executionCmds.add(new ExecutionStep.Command(this.wrapSqlSteps(sqlCommand, tmpSqlFile, true)));
                executionCmds.add(new ExecutionStep.Command(this.wrapSqlSteps("EXIT;", tmpSqlFile)));
                sqlplusCmd = sqlplusCmd + " @" + tmpSqlFile;
                executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
            }
        } else {
            executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
        }
        return executionCmds;
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile) {
        return this.wrapSqlSteps(cmd, tmpSqlFile, false);
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile, boolean firstSqlCmd) {
        if (firstSqlCmd) {
            return "echo \"" + cmd + "\" > " + tmpSqlFile;
        }
        return "echo \"" + cmd + "\" >> " + tmpSqlFile;
    }

    private String getTmpSqlFile(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        String ohName = oh.getName() == null ? "" : oh.getName().replace(" ", "");
        String user = oh.getOwner();
        String tmpSqlFile = "/tmp/" + ohName + "_" + user + ".sql";
        return tmpSqlFile;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            assert (abstractBaseTarget instanceof RACDatabase);
            if (!(abstractBaseTarget instanceof RACDatabase) && !(abstractBaseTarget instanceof SIDatabase)) {
                throw new OPlanException("StopStartRedoApply action can act only on RACDatabase and SIDatabase, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = contextPopulator.populateContext(g, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(cc);
            }
            if (!DBCommandUtils.isPhysicalStandbyDatabase(abstractBaseTarget)) continue;
            logger.info("Current Database is a standby database " + abstractBaseTarget.getName());
            if (DBCommandUtils.isUsingBroker(abstractBaseTarget)) continue;
            ExecutionStep es = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)cc, null);
            es.getCommand().addAll(this.getRedoApplyCommand(es, cc));
            steps.add(es);
        }
        return steps;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(CRSCommandActionType.StartRedoApply.toString()) || a.getType().equals(CRSCommandActionType.StopRedoApply.toString()))) {
                logger.info(" crate stop start log shipping command" + a.getType());
                return new StopStartRedoApply(a, CRSCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

