/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.DBService;
import model.db_crs.DBServiceNode;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.GenericShellCommand;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelocateDatabaseServices
extends GenericShellCommand {
    Logger logger = Logger.getLogger(RelocateDatabaseServices.class.getName());
    private static Map<String, DBServiceNode> switchedNodes = new HashMap<String, DBServiceNode>();

    public RelocateDatabaseServices(CommandAction automationAction) {
        super(automationAction);
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<Object> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        if (CommandUtils.shouldShutdownRACInstance((PatchingPhase)this.getPatchingPhase())) {
            steps = super.generateExecutionSteps(g, actsOnlyOnTargets);
        }
        return steps;
    }

    public List<String> getShellCommands(CommandContext context) {
        RACDBInstance racDBInstance;
        RACDatabase racDatabase;
        String cmd = "";
        ArrayList<String> cmds = null;
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        if (primaryTarget instanceof RACDBInstance && null != (racDatabase = (racDBInstance = (RACDBInstance)primaryTarget).getDbRAC()).getServices() && racDatabase.getServices().size() > 0) {
            for (DBService dbService : racDatabase.getServices()) {
                List<DBServiceNode> activeNodes = this.getActiveNodes(dbService.getConfiguredNodes());
                if (dbService.getIsRunning() && activeNodes.size() == 1 && dbService.getConfiguredNodes().size() > 1) {
                    DBServiceNode activeNode = activeNodes.get(0);
                    if (!racDBInstance.getName().equals(activeNode.getDatabaseInstance()) || !racDBInstance.getHost().getName().equals(activeNode.getHostName())) continue;
                    if (null == cmds) {
                        cmds = new ArrayList<String>();
                    }
                    if (this.automationAction.getType().equals(CRSCommandActionType.StopRelocatedDatabaseServices.toString())) {
                        cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl stop service -d " + racDatabase.getDatabaseName() + " -s " + dbService.getName();
                        DBServiceNode switchedNode = switchedNodes.get(dbService.getName());
                        cmd = dbService.getAdministrationType().equalsIgnoreCase("adminManagedDB") ? cmd + " -i " + switchedNode.getDatabaseInstance() : cmd + " -n " + switchedNode.getHostName();
                        cmds.add(cmd);
                        continue;
                    }
                    cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl relocate service -d " + racDatabase.getDatabaseName() + " -s " + dbService.getName();
                    DBServiceNode configuredNodeForRelocation = this.getConfiguredNodeToRelocate(dbService, activeNode);
                    if (null == configuredNodeForRelocation) continue;
                    cmd = dbService.getAdministrationType().equalsIgnoreCase("adminManagedDB") ? cmd + " -i " + activeNode.getDatabaseInstance() + " -t " + configuredNodeForRelocation.getDatabaseInstance() : cmd + " -currentnode " + activeNode.getHostName() + " -n " + configuredNodeForRelocation.getHostName();
                    cmds.add(cmd);
                    switchedNodes.put(dbService.getName(), configuredNodeForRelocation);
                    continue;
                }
                StringBuffer message = new StringBuffer("Will not switch service ");
                message.append(dbService.getName()).append(" configured on ").append(racDatabase.getName());
                if (!dbService.getIsRunning()) {
                    message.append(" as it is not running.");
                } else if (activeNodes.size() > 1) {
                    message.append(" as it is already running on other node(s).");
                } else if (dbService.getConfiguredNodes().size() <= 1) {
                    message.append(" as it is not configured to run on any other node(s).");
                }
                this.logger.log(Level.WARNING, message.toString());
            }
        }
        return cmds;
    }

    private List<DBServiceNode> getActiveNodes(List<DBServiceNode> configuredNodes) {
        ArrayList<DBServiceNode> activeNodes = new ArrayList<DBServiceNode>();
        for (DBServiceNode node : configuredNodes) {
            if (!node.getIsRunning()) continue;
            activeNodes.add(node);
        }
        return activeNodes;
    }

    private DBServiceNode getConfiguredNodeToRelocate(DBService service, DBServiceNode activeNode) {
        for (DBServiceNode node : service.getConfiguredNodes()) {
            if (node.getDatabaseInstance().equals(activeNode.getDatabaseInstance())) continue;
            return node;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<RelocateDatabaseServices> {
        public RelocateDatabaseServices getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.RelocateDatabaseServices.toString()) && !a.getType().equals(CRSCommandActionType.StopRelocatedDatabaseServices.toString())) {
                return null;
            }
            return new RelocateDatabaseServices((CommandAction)a);
        }
    }
}

