/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.automationselection;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.PatchBundle;
import model.patchmodel.PatchPackage;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.PhaseType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.core.automationselection.AutomationSelection;
import oracle.oplan.db.automationselection.CRSPatchCatalog;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.sdk.SIPatchingContext;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.automationselection.AutomationSetSelection;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.patch.PatchBundlexml;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSAutomationSetSelection
extends AutomationSetSelection {
    private Logger logger = Logger.getLogger(CRSAutomationSetSelection.class.getName());
    boolean higherOplanVersion = false;
    static HashMap<BigInteger, List<String>> automations = CRSPatchCatalog.getAutomationMap();

    protected BigInteger getAutomationHash() {
        PatchPackage patch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        if (patch == null) {
            this.logger.severe("There is no patch in the patch bag.");
            throw new OPlanUserException("EMPTY_PATCH_BUG", new Object[0]);
        }
        if (!(patch instanceof PatchBundle)) {
            this.logger.info("This patch does not contain bundle.xml with a hash, hence returning null for hash.This implies that the patch is either a singleton or an Engineered System Patch.");
            if (!(patch instanceof EngineeredSystemPatch)) {
                this.logger.info("This patch is neither an Engineered System Patch. ");
                OPlan.getInstance().getOPlanEnv().setProperty("SelectivePatchingEnabled", "true");
                SIPatchingContext sipc = new SIPatchingContext(OPlan.getInstance().getSystemInstance(), OPlan.getInstance().getConfigGraph(), false);
                List crss = OPlan.getInstance().getSystemInstance().getTargetsOfType(CRSCluster.class);
                if (null != crss && crss.size() != 0) {
                    sipc.dontTouchGI(new PhaseType[0]);
                }
            }
            return null;
        }
        PatchBundle bp = (PatchBundle)patch;
        this.logger.config("Searching for automations hash for " + bp.getPatchLocation());
        String bundlexml = bp.getBundleXml();
        try {
            PatchBundlexml pbxml = new PatchBundlexml(bundlexml);
            return this.getAutomationHash(pbxml);
        }
        catch (BundleXmlException e) {
            throw new OPlanException("Exception thrown while trying to create bundle patch bundleXml object");
        }
        catch (IOException e) {
            throw new OPlanException("Exception while reading the bundle xml.");
        }
        catch (BundleValidationException e) {
            throw new OPlanException("Couldn't validate the bundle xml of the bundle patch.");
        }
    }

    BigInteger getAutomationHash(PatchBundlexml pbx) {
        BigInteger hash = OPlan.getInstance().getOPlanEnv().getBundleHash();
        if (hash == null) {
            this.logger.info("Hash key was not overridden from cmd line.");
            this.checkMinOplanVersionSatisfied(pbx);
            hash = pbx.getHashOfFullContent();
            BigInteger overrideHash = pbx.getOverriddenHash();
            if (overrideHash != null) {
                this.logger.info("Patch overrides automation hash with: " + overrideHash.toString(16));
                if (!this.higherOplanVersion) {
                    if (automations.containsKey(overrideHash)) {
                        this.logger.info("Same oplan version found: overridden hash is recognized by this version. Proceeding with hash:" + overrideHash.toString(16));
                        hash = overrideHash;
                    }
                } else if (!automations.containsKey(hash)) {
                    this.logger.info("Higher version of oplan found but, does not match any known bundle hash. Going to try overridden hash");
                    hash = overrideHash;
                }
            }
        }
        this.logger.config("Got bundle hash " + hash.toString(16));
        if (!automations.containsKey(hash)) {
            this.logger.info("Bundle hash " + hash + " did not match any automation in patch catalog.");
        }
        return hash;
    }

    public List<URL> selectAutomationSetForPatches() {
        this.logger.config("Searching for automations for the patches");
        return this.selectAutomationSetForPatches(this.getAutomationHash());
    }

    List<URL> selectAutomationSetForPatches(BigInteger hash) {
        List<String> auto_names;
        if (hash == null || automations.get(hash) == null) {
            if (hash == null) {
                this.logger.info("This is not a bundle patch, hence going to select automation based on the target's version.");
            } else {
                this.logger.info("Bundle hash " + hash + " did not match any automation in patch catalog. Hence, going to select automation based on the target's version.");
            }
            auto_names = this.getAutomationsForProductVersion();
            if (auto_names == null) {
                this.logger.severe("No automations found matching product version.");
                throw new OPlanUserException("PATCH_NOT_SUPPORTED", new Object[0]);
            }
            this.logger.info("The automations in oplan side " + auto_names + " matching product version.");
        } else {
            auto_names = automations.get(hash);
        }
        ArrayList<URL> automationFiles = new ArrayList<URL>(auto_names.size());
        for (String autoname : auto_names) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(autoname);
            automationFiles.add(url);
            this.logger.finest("Automation URL:" + url);
        }
        return automationFiles;
    }

    protected String getConfigRootVersion() {
        AbstractBaseTarget root = OPlan.getInstance().getConfigGraph().getRootVertex();
        assert (root != null && root.getVersion() == null);
        this.logger.info("Found " + root + " with version: " + root.getVersion());
        return root.getVersion();
    }

    protected List<String> getAutomationsForProductVersion() {
        String patchVersion;
        String version = this.getConfigRootVersion();
        String oldDBVersion = this.getOldDBVersionIfPatchingOnlyDB(version, patchVersion = this.getPatchVersion());
        if (oldDBVersion != null) {
            version = this.formattedVersion(oldDBVersion);
        }
        for (String ver : CRSPatchCatalog.getProductVersion2AutomationsMap().keySet()) {
            if (!version.startsWith(ver)) continue;
            this.logger.info("Found product version " + version + " begining with target version " + ver + " present in patch catalog");
            List<String> strs = CRSPatchCatalog.getProductVersion2AutomationsMap().get(ver);
            this.logger.fine("Returning automations " + strs + " matching product version " + version);
            return strs;
        }
        this.logger.info("No automations found in the catalog for product version " + version);
        return null;
    }

    private String getOldDBVersionIfPatchingOnlyDB(String rootVersion, String patchVersion) {
        boolean isGIOrSIHAAvailable = false;
        String oldDBVersion = null;
        HashSet<String> setOfOldDBVersion = new HashSet<String>();
        for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            SIDatabase sidb;
            RACDatabase racDB;
            if (bc instanceof OracleHome) {
                OracleHome oh = (OracleHome)bc;
                if (oh.getHomeType().equals("crs")) {
                    if (!DBCommandUtils.isGIMarkedForSkip()) {
                        isGIOrSIHAAvailable = true;
                    }
                } else if (oh.getHomeType().equals("siha") && !DBCommandUtils.isSIHAMarkedForSkip()) {
                    isGIOrSIHAAvailable = true;
                }
            }
            if (bc instanceof RACDatabase && (racDB = (RACDatabase)bc).getVersion() != null && racDB.getProperty(SkipTargetCookie.class) == null && !this.formattedVersion(rootVersion).equals(this.formattedVersion(racDB.getVersion()))) {
                setOfOldDBVersion.add(racDB.getVersion());
            }
            if (!(bc instanceof SIDatabase) || (sidb = (SIDatabase)bc).getVersion() == null || sidb.getProperty(SkipTargetCookie.class) != null || this.formattedVersion(rootVersion).equals(this.formattedVersion(sidb.getVersion()))) continue;
            setOfOldDBVersion.add(sidb.getVersion());
        }
        if (!isGIOrSIHAAvailable) {
            if (setOfOldDBVersion.size() > 1) {
                if (patchVersion == null) {
                    this.logger.severe("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                    throw new OPlanException("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                }
                oldDBVersion = this.getDBVersionMatchingPatchVersion(patchVersion, setOfOldDBVersion);
            } else if (setOfOldDBVersion.size() == 1) {
                oldDBVersion = (String)setOfOldDBVersion.toArray()[0];
            }
        }
        return oldDBVersion;
    }

    private String getDBVersionMatchingPatchVersion(String patchVersion, Set setOfDBVersion) {
        String version = null;
        String[] listOfVersion = new String[setOfDBVersion.size()];
        setOfDBVersion.toArray(listOfVersion);
        for (String ver : listOfVersion) {
            if (!this.formattedVersion(patchVersion).equals(this.formattedVersion(ver))) continue;
            version = ver;
        }
        return version;
    }

    private String getPatchVersion() {
        String version = null;
        PatchPackage patch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        if (patch instanceof EngineeredSystemPatch) {
            List subPatches = ((EngineeredSystemPatch)patch).getSubPatches();
            for (GenericPatch subPatch : subPatches) {
                if (subPatch.getVersion() == null) continue;
                version = subPatch.getVersion();
                break;
            }
        }
        return version;
    }

    private String formattedVersion(String version) {
        String formattedVersion = version;
        if (formattedVersion.split("\\.").length == 5) {
            int index = version.lastIndexOf(".");
            formattedVersion = version.substring(0, index);
        }
        return formattedVersion;
    }

    private void checkMinOplanVersionSatisfied(PatchBundlexml patchBundlexml) {
        if (patchBundlexml.getMinOplanVersion() != null) {
            int ver = OUIDriver.compareOPatchVersion((String)OPlan.getInstance().getOPlanEnv().getOPlanVersion(), (String)patchBundlexml.getMinOplanVersion());
            if (ver > 0) {
                this.higherOplanVersion = true;
            } else if (ver < 0) {
                this.logger.severe("Older version of oplan found. Recommending to upgrade.");
                throw new OPlanUserException("PLEASE_UPGRADE_OPLAN", new Object[]{patchBundlexml.getMinOplanVersion(), OPlan.getInstance().getOPlanEnv().getOPlanVersion()});
            }
        }
    }

    public void addAutomationMap(HashMap<Automation, URL> auto_map, Automation auto, Operation operation, URL automationFile, File autoDir) {
        Logger logger = Logger.getLogger(CRSAutomationSetSelection.class.getName());
        if (this.shouldSelectAutomation(auto, operation)) {
            PatchPackage patch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
            if (patch.getRollingPatch() != null && !patch.getRollingPatch().booleanValue() && auto.getDeploymentSubType() == DeploymentSubType.ROLLING_UPGRADE) {
                return;
            }
            logger.info("Selected automation:" + automationFile.toString());
            if (auto.getDeploymentType() == DeploymentType.IN_PLACE && (auto.getDeploymentSubType() == null || auto.getDeploymentSubType() == DeploymentSubType.ROLLING_UPGRADE) && Strategy.MANUAL.equals((Object)auto.getStrategy())) {
                AbstractBaseTarget top;
                if (this.isExadata()) {
                    logger.info("Selecting DCLI automation.");
                    auto.setStrategy(Strategy.DCLI);
                }
                if (!((top = OPlan.getInstance().getSystemInstance().getTop()) instanceof HAS)) {
                    Automation rollingAuto = AutomationSelection.URLtoAutomation((URL)automationFile);
                    if (patch.getRollingPatch() == null || patch.getRollingPatch().booleanValue()) {
                        rollingAuto.setDeploymentSubType(DeploymentSubType.ROLLING_UPGRADE);
                        auto_map.put(rollingAuto, automationFile);
                    }
                }
                auto.setDeploymentSubType(DeploymentSubType.NON_ROLLING_UPGRADE);
            }
            auto_map.put(auto, automationFile);
            this.saveSelectedAutomation(automationFile, autoDir);
        }
    }

    private boolean shouldSelectAutomation(Automation auto, Operation operation) {
        String candidateOH;
        AbstractBaseTarget top = OPlan.getInstance().getSystemInstance().getTop();
        if (top instanceof HAS) {
            String hasversion = OPlan.getInstance().getSystemInstance().getTop().getVersion();
            if (hasversion.startsWith("11.2") && DeploymentType.IN_PLACE.equals((Object)auto.getDeploymentType()) && DeploymentSubType.ROLLING_UPGRADE.equals((Object)auto.getDeploymentSubType())) {
                return false;
            }
            if (OUIDriver.compareOPatchVersion((String)hasversion, (String)"12.1.0.2.0") == -1 && !hasversion.startsWith("11.2.0.4") && DeploymentType.OUT_OF_PLACE.equals((Object)auto.getDeploymentType())) {
                return false;
            }
        }
        if (!((candidateOH = OPlan.getInstance().getOPlanEnv().getProperty("MoveConfigToOH")) == null || candidateOH.length() <= 0 || auto.getDeploymentType().equals((Object)DeploymentType.OUT_OF_PLACE) && (Operation.APPLY.equals((Object)auto.getOperation()) || Operation.SWITCHBACK.equals((Object)auto.getOperation())))) {
            return false;
        }
        if (Operation.SWITCHBACK.equals((Object)auto.getOperation()) && Operation.APPLY.equals((Object)operation)) {
            return true;
        }
        if (Strategy.AUTO_PATCH.equals((Object)auto.getStrategy()) && !(OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage() instanceof PatchBundle) && !(OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage() instanceof EngineeredSystemPatch)) {
            return false;
        }
        return auto.getOperation().equals((Object)operation);
    }

    private boolean isExadata() {
        CRSCluster crs;
        List crss = OPlan.getInstance().getSystemInstance().getTargetsOfType(CRSCluster.class);
        AbstractBaseTarget rootTarget = OPlan.getInstance().getSystemInstance().getTop();
        return !(crss.size() == 1 ? "NON-EXADATA".equalsIgnoreCase((crs = (CRSCluster)crss.get(0)).getHWtype()) : crss.size() == 0 && rootTarget instanceof HAS);
    }
}

