/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api.install;

import java.io.File;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;

public interface PatchInfo {
    public String getPatchId();

    public String getPatchUpi();

    public PatchSubType getPatchSubType();

    public Map<ComponentInfo, ComponentCheckResult> getPatchComponents();

    public List<InventoryComponentInfo> getInventoryComponents();

    @Deprecated
    public Map<FileState, List<File>> getAffectedFiles();

    public Map<FileState, List<Path>> getAffectedPaths();

    public boolean isRollBack();

    public List<String> getBugList();

    public String getDescription();

    public List<String> getPreReqs();

    public List<Locale> getLanguages();

    public List<String> getSupersededPatches();

    public Calendar getAppliedDate();

    public boolean isMetaDataPatch();

    public static interface Builder {
        public Builder patchId(String var1);

        public Builder patchUpi(String var1);

        public Builder patchSubType(PatchSubType var1);

        public Builder patchComponents(Map<ComponentInfo, ComponentCheckResult> var1);

        public Builder inventoryComponents(List<InventoryComponentInfo> var1);

        @Deprecated
        public Builder affectedFiles(Map<FileState, List<File>> var1);

        public Builder affectedPaths(Map<FileState, List<Path>> var1);

        public Builder rollBack(boolean var1);

        public Builder bugList(List<String> var1);

        public Builder description(String var1);

        public Builder preReqs(List<String> var1);

        public Builder languages(List<Locale> var1);

        public Builder supersededPatches(List<String> var1);

        public Builder appliedDate(Calendar var1);

        public Builder metaDataPatch(boolean var1);

        public PatchInfo build();
    }
}

