/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.ArtifactType;
import oracle.glcm.opatch.common.api.ArtifactTypeMapping;
import oracle.glcm.opatch.common.api.ArtifactTypeMappingException;
import oracle.glcm.opatch.common.api.ArtifactTypeMappingServiceProvider;

public class ArtifactTypeMappingFactory {
    private static final Logger _log = Logger.getLogger(ArtifactTypeMappingFactory.class.getName());
    private static ArtifactTypeMappingFactory _instance;
    private static List<ArtifactTypeMappingServiceProvider> _artifactTypeMappingServiceProviders;

    private ArtifactTypeMappingFactory() {
    }

    public static ArtifactTypeMappingFactory getInstance() {
        if (_instance == null) {
            _instance = new ArtifactTypeMappingFactory();
        }
        return _instance;
    }

    public ArtifactTypeMapping getArtifactTypeMapping(String homeDir) throws ArtifactTypeMappingException {
        return this.getArtifactTypeMapping(homeDir, null);
    }

    public ArtifactTypeMapping getArtifactTypeMapping(String homeDir, String fileSystemType) throws ArtifactTypeMappingException {
        return this.getArtifactTypeMapping(homeDir, fileSystemType, null);
    }

    public ArtifactTypeMapping getArtifactTypeMapping(String homeDir, String fileSystemType, ClassLoader classLoader) throws ArtifactTypeMappingException {
        return this.getArtifactTypeMapping(homeDir, fileSystemType, classLoader, false);
    }

    public ArtifactTypeMapping getArtifactTypeMapping(String homeDir, String fileSystemType, ClassLoader classLoader, boolean reload) throws ArtifactTypeMappingException {
        ArtifactTypeMappingServiceProvider provider = this.getDefaultArtifactTypeMappingServiceProvider(classLoader, reload);
        if (provider == null) {
            throw new ArtifactTypeMappingException("Failed to locate artifact type mapping service provider on classpath.");
        }
        return provider.getArtifactTypeMappingInstance(homeDir, fileSystemType);
    }

    public ArtifactTypeMappingServiceProvider getDefaultArtifactTypeMappingServiceProvider(ClassLoader classLoader, boolean reload) {
        List<ArtifactTypeMappingServiceProvider> providers = this.getArtifactTypeMappingServiceProviders(classLoader, reload);
        return providers.isEmpty() ? null : providers.get(0);
    }

    public List<ArtifactTypeMappingServiceProvider> getArtifactTypeMappingServiceProviders(ClassLoader classLoader, boolean reload) {
        if (_artifactTypeMappingServiceProviders == null || reload) {
            _artifactTypeMappingServiceProviders = new ArrayList<ArtifactTypeMappingServiceProvider>();
            if (classLoader == null) {
                classLoader = ArtifactTypeMappingFactory.class.getClassLoader();
            }
            ServiceLoader<ArtifactTypeMappingServiceProvider> loader = ServiceLoader.load(ArtifactTypeMappingServiceProvider.class, classLoader);
            for (ArtifactTypeMappingServiceProvider instance : loader) {
                _artifactTypeMappingServiceProviders.add(instance);
            }
        }
        return _artifactTypeMappingServiceProviders;
    }

    public static void main(String ... args) throws ArtifactTypeMappingException {
        String homeDir = "";
        String fileSystemType = "";
        String filePath = "";
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-homeDir")) {
                homeDir = args[i + 1];
            }
            if (args[i].equals("-fileSystemType")) {
                fileSystemType = args[i + 1];
            }
            if (!args[i].equals("-filePath")) continue;
            filePath = args[i + 1];
        }
        if (homeDir.isEmpty()) {
            throw new ArtifactTypeMappingException("-homeDir parameter is required.");
        }
        ArtifactTypeMapping mapping = ArtifactTypeMappingFactory.getInstance().getArtifactTypeMapping(homeDir, fileSystemType);
        if (!filePath.isEmpty()) {
            ArtifactType type = mapping.getArtifactType(filePath);
            _log.info("Artifact file type for: " + filePath + " at home: " + homeDir + " is: " + (Object)((Object)type));
        } else {
            for (Map.Entry<String, ArtifactType> map : mapping.getArtifactTypes().entrySet()) {
                _log.info("Artifact file type for: " + map.getKey() + " at home: " + homeDir + " is: " + (Object)((Object)map.getValue()));
            }
            if (mapping.getArtifactTypes().size() == 0) {
                _log.info("No artifact file types are defined for home at: " + homeDir);
            }
        }
    }
}

