/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.readme;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.PhaseType;
import oracle.opatch.system.automation.jaxb.ServiceStatus;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.core.readme.Cmds2Script;
import oracle.oplan.core.readme.HtmlReadmeGenerator;
import oracle.oplan.core.readme.IndexedHtmlReadmeGenerator;
import oracle.oplan.core.readme.IndexedTextReadmeGenerator;
import oracle.oplan.core.readme.TextReadmeGenerator;
import oracle.oplan.core.ui.tree.TextTreeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadmeFactory {
    Logger logger = Logger.getLogger(ReadmeFactory.class.getName());
    private File patchReadme = null;
    private List<ExecutionPlan> plans;
    private DefaultMutableTreeNode tree;
    private HashMap<ExecutionPlan, String> plan2bundle = new HashMap();
    private ExecutionPlan singleExecutionPlan;
    boolean split = false;
    protected HashMap<String, String> productImageMap = new HashMap();
    private static final String DEFAULT_PRODUCT_IMAGE = "default_image";

    public ReadmeFactory() {
        this.productImageMap.put(DEFAULT_PRODUCT_IMAGE, "oracle/opatch/oplan/readme/oracle_em_12c_logo.png");
    }

    public String getProductImage() {
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        return oplanIntgFactory.getLogoLocation();
    }

    public static ReadmeFactory getInstance() {
        return OPlan.getInstance().getReadmeFactory();
    }

    public void generateReadme(List<ExecutionPlan> plans, ConfigGraph configGraph) {
        assert (plans.size() > 0);
        this.plans = plans;
        this.tree = configGraph.createTreeTable();
        this.classifyPlans();
        this.copyPatchReadme();
        if (plans.size() == 1) {
            try {
                new TextReadmeGenerator(this).generateReadme();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Exception while generating text readme", e);
            }
            try {
                new HtmlReadmeGenerator(this).generateReadme();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Exception while generating HTML readme", e);
            }
        } else {
            try {
                new IndexedTextReadmeGenerator(this).generateReadme();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Exception while generating text readme", e);
            }
            try {
                new IndexedHtmlReadmeGenerator(this).generateReadme();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Exception while generating HTML readme", e);
            }
        }
        for (ExecutionPlan plan : plans) {
            try {
                Cmds2Script.cmds2ScriptFile(plan);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not write commands to script.", e);
            }
        }
    }

    public void writePlanToHTML(final File fileName, ExecutionPlan plan) throws IOException {
        this.plans = new ArrayList<ExecutionPlan>();
        this.plans.add(plan);
        this.tree = OPlan.getInstance().getConfigGraph().createTreeTable();
        this.classifyPlans();
        try {
            HtmlReadmeGenerator readmeGen = new HtmlReadmeGenerator(this){

                protected File getReadmeFile() {
                    return fileName;
                }

                protected File getConfigImageFile() {
                    return new File(fileName.getParentFile(), "configuration.png");
                }

                protected File getLogDir() {
                    return fileName.getParentFile();
                }
            };
            readmeGen.generateReadme();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while generating HTML readme", e);
            throw e;
        }
    }

    public void writePlanToText(final File fileName, ExecutionPlan plan) throws IOException {
        this.plans = new ArrayList<ExecutionPlan>();
        this.plans.add(plan);
        this.tree = OPlan.getInstance().getConfigGraph().createTreeTable();
        this.classifyPlans();
        try {
            TextReadmeGenerator readmeGen = new TextReadmeGenerator(this){

                protected File getReadmeFile() {
                    return fileName;
                }
            };
            readmeGen.generateReadme();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while generating HTML readme", e);
            throw e;
        }
    }

    public void writePlanAsGoldenSteps(File file, ExecutionPlan plan) throws IOException {
        Cmds2Script.cmds2ScriptFile(file, plan);
    }

    public List<ExecutionPlan> getPlans() {
        return this.plans;
    }

    public int getSystemInstanceEntityCount() {
        return TextTreeGenerator.getAllNodeCount(this.tree);
    }

    public DefaultMutableTreeNode getConfigTree() {
        return this.tree;
    }

    private void classifyPlans() {
        boolean singleSet = false;
        for (ExecutionPlan plan : this.plans) {
            Automation auto = plan.getAutomation();
            if (!singleSet) {
                this.singleExecutionPlan = plan;
                singleSet = true;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY) && auto.getStrategy().equals((Object)Strategy.MANUAL)) {
                this.plan2bundle.put(plan, "InplaceApplyRollingManual");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY) && auto.getStrategy().equals((Object)Strategy.AUTO_PATCH)) {
                this.plan2bundle.put(plan, "InplaceApplyRollingAuto");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.NON_ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY) && auto.getStrategy().equals((Object)Strategy.MANUAL)) {
                this.plan2bundle.put(plan, "InplaceApplyNonRollingManual");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY) && auto.getStrategy().equals((Object)Strategy.DCLI)) {
                this.plan2bundle.put(plan, "InplaceApplyRollingAuto");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.NON_ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY) && auto.getStrategy().equals((Object)Strategy.DCLI)) {
                this.plan2bundle.put(plan, "InplaceApplyNonRollingDcli");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.OUT_OF_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.APPLY)) {
                this.plan2bundle.put(plan, "OplaceApplyRolling");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.ROLLBACK) && auto.getStrategy().equals((Object)Strategy.MANUAL)) {
                this.plan2bundle.put(plan, "InplaceRollbackRollingManual");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.ROLLBACK) && auto.getStrategy().equals((Object)Strategy.AUTO_PATCH)) {
                this.plan2bundle.put(plan, "InplaceRollbackRollingAuto");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.NON_ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.ROLLBACK) && auto.getStrategy().equals((Object)Strategy.MANUAL)) {
                this.plan2bundle.put(plan, "InplaceRollbackNonRollingManual");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.IN_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.NON_ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.ROLLBACK) && auto.getStrategy().equals((Object)Strategy.DCLI)) {
                this.plan2bundle.put(plan, "InplaceRollbackNonRollingDcli");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.OUT_OF_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.ROLLBACK)) {
                this.plan2bundle.put(plan, "OplaceRollbackRolling");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.OUT_OF_PLACE) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE) && auto.getOperation().equals((Object)Operation.SWITCHBACK)) {
                this.plan2bundle.put(plan, "OplaceSwitchbackRolling");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.DEFAULT) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.DEFAULT) && auto.getOperation().equals((Object)Operation.APPLY)) {
                this.plan2bundle.put(plan, "DefaultApply");
                continue;
            }
            if (auto.getDeploymentType().equals((Object)DeploymentType.DEFAULT) && auto.getDeploymentSubType().equals((Object)DeploymentSubType.DEFAULT) && auto.getOperation().equals((Object)Operation.ROLLBACK)) {
                this.plan2bundle.put(plan, "DefaultRollback");
                continue;
            }
            this.logger.severe("Automation not (yet) recognized!\n" + auto);
        }
    }

    public ExecutionPlan getSingleExecutionPlan() {
        return ExeuctionPlanUtil.first(this.getPlans());
    }

    public String getBundleMessagePrefix(ExecutionPlan plan) {
        String ret = this.plan2bundle.get(plan);
        return ret == null ? "" : ret;
    }

    public static String getStrategyBundlePrefixKey(ExecutionPlan plan) {
        Strategy strat = plan.getAutomation().getStrategy();
        if (strat == null) {
            return "";
        }
        if (Strategy.AUTO_PATCH.equals((Object)strat)) {
            return "AUTO";
        }
        if (Strategy.MANUAL.equals((Object)strat)) {
            return "MANUAL";
        }
        if (Strategy.DCLI.equals((Object)strat)) {
            return "DCLI";
        }
        return "";
    }

    public static String getOperationBundlePropertySuffixKey(ExecutionPlan plan) {
        Operation op = plan.getAutomation().getOperation();
        if (op == null) {
            return "";
        }
        if (Operation.APPLY.equals((Object)op)) {
            return "APPLY";
        }
        if (Operation.ROLLBACK.equals((Object)op)) {
            return "ROLLBACK";
        }
        if (Operation.SWITCHBACK.equals((Object)op)) {
            return "SWITCHBACK";
        }
        return "";
    }

    public File getFileForTxtInstructions(ExecutionPlan plan) {
        File readme = OPlan.getInstance().getLogInfo().getReadmeTxt();
        if (readme.isFile()) {
            readme = readme.getParentFile();
            return new File(readme, this.getBundleMessagePrefix(plan) + ".txt");
        }
        readme = readme.getParentFile();
        int index = 1;
        File file = new File(readme, this.getBundleMessagePrefix(plan) + "_" + index + ".txt");
        while (file.exists()) {
            file = new File(readme, this.getBundleMessagePrefix(plan) + "_" + ++index + ".txt");
        }
        return file;
    }

    public static String getPhaseTitle(ExecutionPlan plan, ExecutionPhase phase) {
        Logger logger = Logger.getLogger(ReadmeFactory.class.getName());
        String res = "";
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        if (ExecutionPhase.PhaseType.ANALYSIS.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "OPERATION_ANALYSIS_PHASE", new Object[0]);
        }
        if (ExecutionPhase.PhaseType.PRE_PATCH.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "PRE_OPERATION_PHASE", new Object[0]);
        }
        if (ExecutionPhase.PhaseType.PATCH.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "OPERATION_PHASE", new Object[0]);
        }
        if (ExecutionPhase.PhaseType.POST_PATCH.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "POST_OPERATION_PHASE", new Object[0]);
        }
        if (ExecutionPhase.PhaseType.POST_PATCH_GI.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "POST_OPERATION_GI_PHASE", new Object[0]);
        }
        if (ExecutionPhase.PhaseType.POST_PATCH_RAC.equals((Object)phase.getPhaseType())) {
            res = OPlanBundle.getPrefixedReadmeMessage(operation, "POST_OPERATION_RAC_PHASE", new Object[0]);
        }
        if ("".equals(res)) {
            logger.severe("Do not recognize phase string: " + (Object)((Object)phase.getPhaseType()));
        }
        return res;
    }

    public String getDowntime(ExecutionPhase phase) {
        if (ServiceStatus.UP.equals((Object)phase.getServiceStatus())) {
            return OPlanBundle.getReadmeMessage("NO_DOWNTIME", new Object[0]);
        }
        if (ServiceStatus.LIMITED.equals((Object)phase.getServiceStatus())) {
            return OPlanBundle.getReadmeMessage("PARTIAL_DOWNTIME", new Object[0]);
        }
        if (ServiceStatus.DOWN.equals((Object)phase.getServiceStatus())) {
            return OPlanBundle.getReadmeMessage("FULL_DOWNTIME", new Object[0]);
        }
        return "";
    }

    public List<String> getStepsStats(ExecutionPlan plan, String highlightStart, String highlightEnd) {
        int nodown = 0;
        int down = 0;
        int partial = 0;
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            if (ServiceStatus.DOWN.equals((Object)phase.getServiceStatus())) {
                down += phase.getExecutionStep().size();
            }
            if (ServiceStatus.UP.equals((Object)phase.getServiceStatus())) {
                nodown += phase.getExecutionStep().size();
            }
            if (!ServiceStatus.LIMITED.equals((Object)phase.getServiceStatus())) continue;
            partial += phase.getExecutionStep().size();
        }
        int all = down + nodown + partial;
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(OPlanBundle.getReadmeMessage("TOTAL_STEPS", all, highlightStart, highlightEnd));
        if (nodown != 0) {
            ret.add(OPlanBundle.getReadmeMessage("FULL_AVAIL_STEPS", nodown, highlightStart, highlightEnd));
        }
        if (partial != 0) {
            ret.add(OPlanBundle.getReadmeMessage("PARTIAL_AVAIL_STEPS", partial, highlightStart, highlightEnd));
        }
        if (down != 0) {
            ret.add(OPlanBundle.getReadmeMessage("FULL_DOWN_STEPS", down, highlightStart, highlightEnd));
        }
        return ret;
    }

    public File getPatchReadme() {
        return this.patchReadme;
    }

    protected void copyPatchReadme() {
        File source = null;
        source = this.findFile("readme.html");
        if (source == null) {
            source = this.findFile("readme.txt");
            if (source == null) {
                source = this.findFile("readme");
            }
            if (source == null) {
                return;
            }
        }
        File logDir = OPlan.getInstance().getLogInfo().getLogDir();
        this.patchReadme = new File(logDir, source.getName());
        try {
            IOUtils.copyFile(source, this.patchReadme);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Could not copy patch README.html/txt", e);
            this.patchReadme = null;
        }
    }

    private File findFile(String in) {
        final String name = in;
        File patchRoot = OPlan.getInstance().getOPlanEnv().getBundlePatchloc();
        File[] tmp = patchRoot.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                return name.equalsIgnoreCase(fileName);
            }
        });
        if (tmp != null && tmp.length > 0) {
            return tmp[0];
        }
        return null;
    }

    private List<Host> getAllHostList() {
        List<Host> hostList = null;
        ConfigGraph g = OPlan.getInstance().getConfigGraph();
        hostList = g.getTargets(Host.class);
        if (hostList == null || hostList.size() == 0) {
            throw new OPlanUserException("EMPTY_HOST_LIST_ERROR", new Object[0]);
        }
        return hostList;
    }

    private Host getLastHost() {
        List<Host> HostList = this.getAllHostList();
        if (HostList != null && HostList.size() > 0) {
            return HostList.get(HostList.size() - 1);
        }
        return null;
    }

    public List<Set<String>> getSplitHostList() {
        List<Host> HostList = this.getAllHostList();
        ArrayList<Set<String>> splitHostList = new ArrayList<Set<String>>();
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        int nodeNumberPerReadme = -1;
        if (env.getProperty("NodeNumberPerReadme") != null && Integer.valueOf(env.getProperty("NodeNumberPerReadme")) > 0) {
            this.split = true;
            nodeNumberPerReadme = Integer.valueOf(env.getProperty("NodeNumberPerReadme"));
        } else {
            nodeNumberPerReadme = HostList.size();
            this.split = false;
        }
        int i = 0;
        while (i < HostList.size()) {
            HashSet<String> filterHosts = new HashSet<String>();
            for (int j = 0; j < nodeNumberPerReadme && i < HostList.size(); ++j) {
                filterHosts.add(HostList.get(i++).getHostName());
            }
            splitHostList.add(filterHosts);
        }
        return splitHostList;
    }

    protected boolean IsPostPatchPhase(ExecutionPhase phase) {
        if (phase.getPhaseType() == ExecutionPhase.PhaseType.POST_PATCH) {
            return true;
        }
        if (phase.getPhaseType() == null) {
            PatchingPhase aPhase = phase.getAutomationPatchingPhase();
            if (aPhase.getPhaseType() == PhaseType.POST_APPLY || aPhase.getPhaseType() == PhaseType.POST_ROLLBACK) {
                return true;
            }
            if ((aPhase.getPhaseType() == PhaseType.POST_MIGRATE || aPhase.getPhaseType() == PhaseType.POST_SWITCHBACK) && aPhase.getActsOnTargetType().equals("RACDatabase")) {
                return true;
            }
        }
        return false;
    }

    public void changeHostOfPostPhase(ExecutionPlan plan) {
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        if (env.getProperty("NodeNumberPerReadme") != null && Integer.valueOf(env.getProperty("NodeNumberPerReadme")) > 0 && !plan.getAutomation().getStrategy().equals((Object)Strategy.DCLI)) {
            List<ExecutionPhase> phaseList = plan.getExecutionPhase();
            for (ExecutionPhase phase : phaseList) {
                if (!this.IsPostPatchPhase(phase)) continue;
                List<ExecutionStep> executionStepList = phase.getExecutionStep();
                for (ExecutionStep executionStep : executionStepList) {
                    if (executionStep.getHost().getName().equals(this.getLastHost().getName())) continue;
                    executionStep.setHost(this.getLastHost());
                }
            }
        }
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }
}

