/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.oplan.configcompare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.Host;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareException;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareResult;
import oracle.osysmodel.utils.configdiff.ConfigDiff;
import oracle.osysmodel.utils.configdiff.ConfigDiffException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigCompareHelper {
    Logger logger = Logger.getLogger(ConfigCompareHelper.class.getName());

    protected Set<String> processSystemInstanceToSkipUnSupportedVersionTarget(SystemInstance si) {
        this.logger.fine("Preprocess of system instance " + si);
        return new HashSet<String>();
    }

    private Map<Host, String> processSystemInstancesToCheckHostNames(SystemInstance firstInstance, SystemInstance secondInstance) {
        this.logger.info("Starting preprocess of system instances ");
        HashMap<Host, String> hostMap = new HashMap<Host, String>();
        ArrayList hostList = new ArrayList();
        hostList.addAll(firstInstance.getTargetsOfType(Host.class));
        hostList.addAll(secondInstance.getTargetsOfType(Host.class));
        for (Host host : hostList) {
            if (host == null || host.getHostName() == null || host.getHostName().equals(host.getHostName().toLowerCase())) continue;
            hostMap.put(host, host.getHostName());
            host.setHostName(host.getHostName().toLowerCase());
        }
        return hostMap;
    }

    public final ConfigCompareResult compareIfSystemInstanceAreSame(SystemInstance firstInstance, SystemInstance secondInstance) throws ConfigCompareException {
        this.logger.log(Level.INFO, "Starting configuration compare...");
        Set<String> firstSet = this.processSystemInstanceToSkipUnSupportedVersionTarget(firstInstance);
        Set<String> secondSet = this.processSystemInstanceToSkipUnSupportedVersionTarget(secondInstance);
        Map<Host, String> hostInfo = this.processSystemInstancesToCheckHostNames(firstInstance, secondInstance);
        ConfigDiff configDiffResult = ConfigDiff.getInstance((SystemInstance)firstInstance, (SystemInstance)secondInstance, null);
        try {
            configDiffResult.diff();
        }
        catch (ConfigDiffException e) {
            throw new ConfigCompareException(e);
        }
        this.processToResetHostNames(hostInfo);
        ArrayList<String> firstInstanceSkippedHomes = new ArrayList<String>();
        for (String string : firstSet) {
            firstInstanceSkippedHomes.add(string);
        }
        ArrayList<String> secondInstanceSkippedHomes = new ArrayList<String>();
        for (String s : secondSet) {
            secondInstanceSkippedHomes.add(s);
        }
        ConfigCompareResult configCompareResult = new ConfigCompareResult(configDiffResult, firstInstanceSkippedHomes, secondInstanceSkippedHomes);
        return configCompareResult;
    }

    private void processToResetHostNames(Map<Host, String> originalHostMap) {
        this.logger.info("Starting postprocess of system instances");
        if (null != originalHostMap) {
            for (Host host : originalHostMap.keySet()) {
                host.setHostName(originalHostMap.get(host));
            }
        }
    }
}

