/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.intg;

import java.util.Comparator;
import model.SystemInstance;
import model.common.Host;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.automationselection.AutomationSetSelection;
import oracle.oplan.sdk.cmdtranslator.CommandFactory;
import oracle.oplan.sdk.cookies.MakeCloneHome;
import oracle.oplan.sdk.engine.ContextPopulator;
import oracle.oplan.sdk.engine.SequencingEngineUtils;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.PreProcessor;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareHelper;
import oracle.oplan.sdk.patch.ApplicabilityTarget;
import oracle.oplan.sdk.ui.SystemInstance2UI;
import oracle.oplan.sdk.validation.IsConfigSupported;
import oracle.osysmodel.driver.sdk.productdriver.DummyProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.validation.ConfigValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OPlanIntgFactory {
    protected ProductDriver productDriver;
    protected AutomationSetSelection automationSetSelection;
    protected CommandFactory commandFactory;
    protected ConfigGraph configGraph;
    protected ContextPopulator contextPopulator;
    protected SequencingEngineUtils sequencingEngineUtils;
    protected PreProcessor preProcessor;
    protected ApplicabilityTarget applicabilityTarget;
    protected MakeCloneHome makeCloneHome;
    protected IsConfigSupported isConfigSupported;
    protected DummyProductDriver dummyProductDriver;
    protected SystemInstance2UI systemInstance2UI;
    protected ConfigCompareHelper configCompareHelper;
    protected Comparator<Host> hostComparator;
    protected String logoLocation = "oracle/oplan/core/readme/oracle_em_12c_logo.png";
    protected String logoDesc = "Patching";
    protected String readmeResourceBundleLocation = "oracle/oplan/core/readme/Bundle.properties";
    protected String autoResourceBundleLocation = "oracle/oplan/sdk/resource/AutomationBundle.properties";

    protected abstract ProductDriver getProductDriverInstance();

    public ProductDriver getProductDriver() {
        if (this.productDriver == null) {
            this.productDriver = this.getProductDriverInstance();
        }
        return this.productDriver;
    }

    protected abstract DummyProductDriver getDummyProductDriverInstance();

    public DummyProductDriver getDummyProductDriver() {
        if (this.dummyProductDriver == null) {
            this.dummyProductDriver = this.getDummyProductDriverInstance();
        }
        return this.dummyProductDriver;
    }

    public CommandFactory getCommandFactory() {
        if (this.commandFactory == null) {
            this.commandFactory = new CommandFactory();
        }
        return this.commandFactory;
    }

    public ApplicabilityTarget getApplicabilityTarget() {
        if (this.applicabilityTarget == null) {
            this.applicabilityTarget = new ApplicabilityTarget();
        }
        return this.applicabilityTarget;
    }

    public ConfigGraph getConfigGraph(SystemInstance systemInstance, Host localHost) {
        if (this.configGraph == null) {
            this.configGraph = new ConfigGraph(systemInstance, localHost);
        }
        return this.configGraph;
    }

    public ContextPopulator getContextPopulator() {
        if (this.contextPopulator == null) {
            this.contextPopulator = new ContextPopulator();
        }
        return this.contextPopulator;
    }

    public AutomationSetSelection getAutomationSetSelection() {
        if (this.automationSetSelection == null) {
            this.automationSetSelection = new AutomationSetSelection();
        }
        return this.automationSetSelection;
    }

    public IsConfigSupported getIsConfigSupported(SystemInstance config, ExecutionMode exeMode) throws ConfigValidationException {
        if (this.isConfigSupported == null) {
            this.isConfigSupported = new IsConfigSupported(config, exeMode);
        }
        return this.isConfigSupported;
    }

    public String getLogoLocation() {
        return this.logoLocation;
    }

    public String getLogoDesc() {
        return this.logoDesc;
    }

    public String getReadmeResourceBundleLocation() {
        return this.readmeResourceBundleLocation;
    }

    public String getAutomationResourceBundleLocation() {
        return this.autoResourceBundleLocation;
    }

    public SequencingEngineUtils getSequencingEngineUtils() {
        if (this.sequencingEngineUtils == null) {
            this.sequencingEngineUtils = new SequencingEngineUtils();
        }
        return this.sequencingEngineUtils;
    }

    public PreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public SystemInstance2UI getSystemInstance2UI() {
        if (this.systemInstance2UI == null) {
            this.systemInstance2UI = new SystemInstance2UI();
        }
        return this.systemInstance2UI;
    }

    @Deprecated
    public MakeCloneHome getMakeCloneHome(ProductDriver pd, ConfigGraph cg) {
        if (this.makeCloneHome == null) {
            this.makeCloneHome = new MakeCloneHome(pd, cg);
        }
        return this.makeCloneHome;
    }

    public MakeCloneHome getMakeCloneHome(ConfigGraph cg, LocalInfo localInfo) {
        if (this.makeCloneHome == null) {
            this.makeCloneHome = new MakeCloneHome(cg, localInfo);
        }
        return this.makeCloneHome;
    }

    public ConfigCompareHelper getConfigCompareHelper() {
        if (this.configCompareHelper == null) {
            this.configCompareHelper = new ConfigCompareHelper();
        }
        return this.configCompareHelper;
    }

    public Comparator<Host> getHostComparator() {
        if (this.hostComparator == null) {
            this.hostComparator = new ProductDriver.HostComparator();
        }
        return this.hostComparator;
    }

    public boolean ifSelectAutomationFilesOnlyFromIntegration() {
        return false;
    }
}

