/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model.common.Host;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByHost {
    private final ExecutionPhase phase;
    private List<HostGroup> hostGrouping = new ArrayList<HostGroup>();
    private boolean worthGrouping = true;
    private static final Map<ExecutionPhase, GroupByHost> cache = new HashMap<ExecutionPhase, GroupByHost>();

    private GroupByHost(ExecutionPhase phase) {
        this.phase = phase;
        this.makeHostGroup();
    }

    private GroupByHost(ExecutionPhase phase, Set<String> filterHosts) {
        this.phase = phase;
        this.makeHostGroup(filterHosts);
    }

    public static GroupByHost getInstance(ExecutionPhase phase) {
        GroupByHost res = cache.get(phase);
        if (res == null) {
            res = new GroupByHost(phase);
        }
        return res;
    }

    public static GroupByHost getInstance(ExecutionPhase phase, Set<String> filterHosts) {
        GroupByHost res = cache.get(phase);
        if (res == null) {
            res = new GroupByHost(phase, filterHosts);
        }
        return res;
    }

    public boolean isWorthGrouping() {
        return this.worthGrouping;
    }

    private boolean shouldAddHost(Host host, Set<String> filterHosts) {
        List<Host> allHosts = OPlan.getInstance().getConfigGraph().getTargets(Host.class);
        if (filterHosts.contains(host.getHostName())) {
            return true;
        }
        return !allHosts.contains(host);
    }

    private List<HostGroup> makeHostGroup(Set<String> filterHosts) {
        HostGroup prev = null;
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (ExecutionStep step : this.phase.getExecutionStep()) {
            Host host = step.getHost();
            if (!this.shouldAddHost(host, filterHosts)) continue;
            if (prev == null || prev.getHost() != null && !prev.getHost().equals(host)) {
                prev = new HostGroup(host);
                prev.getExecSteps().add(step);
                this.getHostGrouping().add(prev);
                if (hosts.contains(host)) {
                    this.worthGrouping = false;
                }
                hosts.add(host);
                continue;
            }
            prev.getExecSteps().add(step);
        }
        return this.getHostGrouping();
    }

    private List<HostGroup> makeHostGroup() {
        HostGroup prev = null;
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (ExecutionStep step : this.phase.getExecutionStep()) {
            Host host = step.getHost();
            if (prev == null || prev.getHost() != null && !prev.getHost().equals(host)) {
                prev = new HostGroup(host);
                prev.getExecSteps().add(step);
                this.getHostGrouping().add(prev);
                if (hosts.contains(host)) {
                    this.worthGrouping = false;
                }
                hosts.add(host);
                continue;
            }
            prev.getExecSteps().add(step);
        }
        return this.getHostGrouping();
    }

    public List<HostGroup> getHostGrouping() {
        return this.hostGrouping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HostGroup {
        Host host;
        List<ExecutionStep> execSteps;

        public HostGroup(Host host) {
            this.host = host;
        }

        public Host getHost() {
            return this.host;
        }

        public void setHost(Host host) {
            this.host = host;
        }

        public List<ExecutionStep> getExecSteps() {
            if (this.execSteps == null) {
                this.execSteps = new ArrayList<ExecutionStep>();
            }
            return this.execSteps;
        }
    }
}

